/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.editor;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.editor.AbstractConfigurationInterfaceFormEditor;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.ci.form.page.EnvironmentSettingsPage;
import info.novatec.inspectit.rcp.ci.listener.IEnvironmentChangeListener;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class EnvironmentEditor
extends AbstractConfigurationInterfaceFormEditor
implements IEnvironmentChangeListener {
    public static final String ID = "info.novatec.inspectit.rcp.ci.editor.environmentEditor";

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof EnvironmentEditorInput)) {
            throw new PartInitException("Editor input must be of a type: " + EnvironmentEditorInput.class.getName());
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)iEditorInput;
        this.setPartName(environmentEditorInput.getName());
        this.setTitleImage(ImageFormatter.getEnvironmentImage(environmentEditorInput.getEnvironment()));
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addEnvironmentChangeListener(this);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new EnvironmentSettingsPage(this));
        }
        catch (PartInitException partInitException) {
            InspectIT.getDefault().log(4, "Error occurred trying to open the Environment editor.", partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Saving environment..", -1);
        if (!this.checkValid()) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.getEditorInput();
        CmrRepositoryDefinition cmrRepositoryDefinition = environmentEditorInput.getCmrRepositoryDefinition();
        Environment environment = environmentEditorInput.getEnvironment();
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            try {
                this.commitPages(true);
                Environment environment2 = cmrRepositoryDefinition.getConfigurationInterfaceService().updateEnvironment(environment);
                if (environment2 != null) {
                    InspectIT.getDefault().getInspectITConfigurationInterfaceManager().environmentUpdated(environment2, cmrRepositoryDefinition);
                }
                this.setExceptionOnSave(false);
                this.editorDirtyStateChanged();
            }
            catch (BusinessException businessException) {
                iProgressMonitor.setCanceled(true);
                this.setExceptionOnSave(true);
                this.editorDirtyStateChanged();
                InspectIT.getDefault().createErrorDialog("Saving of the environment '" + environment.getName() + "' failed due to the exception on the CMR.", businessException, -1);
            }
            catch (Throwable throwable) {
                iProgressMonitor.setCanceled(true);
                this.setExceptionOnSave(true);
                this.editorDirtyStateChanged();
                InspectIT.getDefault().createErrorDialog("Unexpected exception occurred during an attempt to save the environment '" + environment.getName() + "'.", throwable, -1);
            }
        } else {
            iProgressMonitor.setCanceled(true);
            InspectIT.getDefault().createErrorDialog("Saving of the environment '" + environment.getName() + "' failed because CMR is currently not online.", -1);
        }
        iProgressMonitor.done();
    }

    @Override
    public void environmentCreated(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void environmentUpdated(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.getEditorInput();
        if (!Objects.equals(cmrRepositoryDefinition, environmentEditorInput.getCmrRepositoryDefinition())) {
            return;
        }
        if (Objects.equals(environmentEditorInput.getEnvironment().getId(), environment.getId())) {
            final EnvironmentEditorInput environmentEditorInput2 = new EnvironmentEditorInput(environment, environmentEditorInput.getProfiles(), environmentEditorInput.getCmrRepositoryDefinition());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EnvironmentEditor.this.setPartName(environmentEditorInput2.getName());
                    EnvironmentEditor.this.setTitleImage(ImageFormatter.getEnvironmentImage(environmentEditorInput2.getEnvironment()));
                    EnvironmentEditor.this.setInputWithNotify(environmentEditorInput2);
                }
            });
        }
    }

    @Override
    public void environmentDeleted(Environment environment, CmrRepositoryDefinition cmrRepositoryDefinition) {
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.getEditorInput();
        if (!Objects.equals(cmrRepositoryDefinition, environmentEditorInput.getCmrRepositoryDefinition())) {
            return;
        }
        if (Objects.equals(environmentEditorInput.getEnvironment().getId(), environment.getId())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EnvironmentEditor.this.close(false);
                }
            });
        }
    }

    public void dispose() {
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeEnvironmentChangeListener(this);
        super.dispose();
    }
}

