/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.editor;

import info.novatec.inspectit.ci.AgentMappings;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.editor.AbstractConfigurationInterfaceFormEditor;
import info.novatec.inspectit.rcp.ci.form.input.AgentMappingInput;
import info.novatec.inspectit.rcp.ci.form.page.AgentMappingPage;
import info.novatec.inspectit.rcp.ci.listener.IAgentMappingsChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class AgentMappingEditor
extends AbstractConfigurationInterfaceFormEditor
implements IAgentMappingsChangeListener {
    public static final String ID = "info.novatec.inspectit.rcp.ci.editor.agentMappingEditor";

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof AgentMappingInput)) {
            throw new PartInitException("Editor input must be of a type: " + AgentMappingInput.class.getName());
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        AgentMappingInput agentMappingInput = (AgentMappingInput)iEditorInput;
        this.setPartName(agentMappingInput.getName());
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().addAgentMappingsChangeListener(this);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new AgentMappingPage(this));
        }
        catch (PartInitException partInitException) {
            InspectIT.getDefault().log(4, "Error occurred trying to open the Agent Mappings editor.", partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Saving agent mappings..", -1);
        if (!this.checkValid()) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        AgentMappingInput agentMappingInput = (AgentMappingInput)this.getEditorInput();
        CmrRepositoryDefinition cmrRepositoryDefinition = agentMappingInput.getCmrRepositoryDefinition();
        AgentMappings agentMappings = agentMappingInput.getAgentMappings();
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            try {
                this.commitPages(true);
                AgentMappings agentMappings2 = cmrRepositoryDefinition.getConfigurationInterfaceService().saveAgentMappings(agentMappings);
                if (agentMappings2 != null) {
                    InspectIT.getDefault().getInspectITConfigurationInterfaceManager().agentMappingsUpdated(agentMappings2, cmrRepositoryDefinition);
                }
                this.setExceptionOnSave(false);
                this.editorDirtyStateChanged();
            }
            catch (BusinessException businessException) {
                iProgressMonitor.setCanceled(true);
                this.setExceptionOnSave(true);
                this.editorDirtyStateChanged();
                InspectIT.getDefault().createErrorDialog("Saving of the agent mappings failed due to the exception on the CMR.", businessException, -1);
            }
            catch (Throwable throwable) {
                iProgressMonitor.setCanceled(true);
                this.setExceptionOnSave(true);
                this.editorDirtyStateChanged();
                InspectIT.getDefault().createErrorDialog("Unexpected exception occurred during an attempt to save the agent mappings.", throwable, -1);
            }
        } else {
            iProgressMonitor.setCanceled(true);
            InspectIT.getDefault().createErrorDialog("Saving of the agent mappings failed because CMR is currently not online.", -1);
        }
        iProgressMonitor.done();
    }

    @Override
    public void agentMappingsUpdated(AgentMappings agentMappings, CmrRepositoryDefinition cmrRepositoryDefinition) {
        AgentMappingInput agentMappingInput = (AgentMappingInput)this.getEditorInput();
        if (!Objects.equals(cmrRepositoryDefinition, agentMappingInput.getCmrRepositoryDefinition())) {
            return;
        }
        final AgentMappingInput agentMappingInput2 = new AgentMappingInput(agentMappingInput.getCmrRepositoryDefinition(), agentMappings, agentMappingInput.getEnvironments());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AgentMappingEditor.this.setPartName(agentMappingInput2.getName());
                AgentMappingEditor.this.setInputWithNotify(agentMappingInput2);
            }
        });
    }

    public void dispose() {
        InspectIT.getDefault().getInspectITConfigurationInterfaceManager().removeAgentMappingsChangeListener(this);
        super.dispose();
    }
}

