/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.dialog;

import info.novatec.inspectit.ci.context.AbstractContextCapture;
import info.novatec.inspectit.ci.context.impl.FieldContextCapture;
import info.novatec.inspectit.ci.context.impl.ParameterContextCapture;
import info.novatec.inspectit.ci.context.impl.ReturnContextCapture;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.validation.IControlValidationListener;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CaptureContextDialog
extends TitleAreaDialog
implements IControlValidationListener {
    private AbstractContextCapture contextCapture;
    private List<ValidationControlDecoration<?>> validationControlDecorations = new ArrayList();
    private List<String> paths = new ArrayList<String>();
    private Button okButton;
    private Button returnButton;
    private Button parameterButton;
    private Button fieldButton;
    private Text nameText;
    private Text accessorText;
    private Button addPath;
    private Button clearPaths;
    private Label indexLabel;
    private Text indexText;
    private Label fieldLabel;
    private Text fieldText;

    public CaptureContextDialog(Shell shell) {
        this(shell, null);
    }

    public CaptureContextDialog(Shell shell, AbstractContextCapture abstractContextCapture) {
        super(shell);
        this.contextCapture = abstractContextCapture;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add Context Capture");
    }

    public void create() {
        super.create();
        this.setTitle("Add Context Capture");
        this.setMessage("Define type of the context capturing", 1);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, false);
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.contextCapture != null);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            if (this.returnButton.getSelection()) {
                this.contextCapture = new ReturnContextCapture();
            } else if (this.parameterButton.getSelection()) {
                ParameterContextCapture parameterContextCapture = new ParameterContextCapture();
                parameterContextCapture.setIndex(Integer.parseInt(this.indexText.getText()));
                this.contextCapture = parameterContextCapture;
            } else if (this.fieldButton.getSelection()) {
                FieldContextCapture fieldContextCapture = new FieldContextCapture();
                fieldContextCapture.setFieldName(this.fieldText.getText());
                this.contextCapture = fieldContextCapture;
            }
            this.contextCapture.setDisplayName(this.nameText.getText());
            if (CollectionUtils.isNotEmpty(this.paths)) {
                this.contextCapture.setPaths(this.paths);
            }
        }
        super.buttonPressed(n);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 400;
        gridData.minimumHeight = 250;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Catch type:");
        this.returnButton = new Button(composite2, 16);
        this.returnButton.setText("Return value");
        this.returnButton.setImage(InspectIT.getDefault().getImage("/icons/selfmade/return.png"));
        this.returnButton.setSelection(this.contextCapture == null || this.contextCapture instanceof ReturnContextCapture);
        this.returnButton.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.createInfoLabel(composite2, "Select for capturing the return value.");
        new Label(composite2, 0);
        this.parameterButton = new Button(composite2, 16);
        this.parameterButton.setText("Parameter");
        this.parameterButton.setImage(InspectIT.getDefault().getImage("/icons/selfmade/parameter.png"));
        this.parameterButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.parameterButton.setSelection(this.contextCapture instanceof ParameterContextCapture);
        this.indexLabel = new Label(composite2, 131072);
        this.indexLabel.setText("Index:");
        this.indexLabel.setVisible(this.contextCapture instanceof ParameterContextCapture);
        this.indexLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.indexText = new Text(composite2, 133120);
        this.indexText.setText("0");
        this.indexText.setVisible(this.contextCapture instanceof ParameterContextCapture);
        this.indexText.setEnabled(this.contextCapture instanceof ParameterContextCapture);
        this.indexText.setLayoutData((Object)new GridData(4, 4, false, false));
        final ValidationControlDecoration<Text> validationControlDecoration = new ValidationControlDecoration<Text>(this.indexText, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                try {
                    return Integer.parseInt(text.getText()) >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        };
        validationControlDecoration.setDescriptionText("Index must be a zero-positive index of parameter in a method.");
        validationControlDecoration.registerListener(24);
        this.parameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = CaptureContextDialog.this.parameterButton.getSelection();
                CaptureContextDialog.this.indexLabel.setVisible(bl);
                CaptureContextDialog.this.indexText.setVisible(bl);
                CaptureContextDialog.this.indexText.setEnabled(bl);
                CaptureContextDialog.this.indexText.setFocus();
                CaptureContextDialog.this.indexText.setSelection(0, CaptureContextDialog.this.indexText.getText().length());
                validationControlDecoration.executeValidation();
            }
        });
        this.createInfoLabel(composite2, "Select for capturing the method parameter value. Specify the correct index of the parameter in the method.");
        new Label(composite2, 0);
        this.fieldButton = new Button(composite2, 16);
        this.fieldButton.setText("Field");
        this.fieldButton.setImage(InspectIT.getDefault().getImage("/icons/selfmade/field.png"));
        this.fieldButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fieldButton.setSelection(this.contextCapture instanceof FieldContextCapture);
        this.fieldLabel = new Label(composite2, 131072);
        this.fieldLabel.setText("Named:");
        this.fieldLabel.setVisible(this.contextCapture instanceof FieldContextCapture);
        this.fieldLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fieldText = new Text(composite2, 133120);
        this.fieldText.setText("myField");
        this.fieldText.setVisible(this.contextCapture instanceof FieldContextCapture);
        this.fieldText.setEnabled(this.contextCapture instanceof FieldContextCapture);
        this.fieldText.setLayoutData((Object)new GridData(4, 4, false, false));
        final ValidationControlDecoration<Text> validationControlDecoration2 = new ValidationControlDecoration<Text>(this.fieldText, null, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                return StringUtils.isNotBlank((String)text.getText());
            }
        };
        validationControlDecoration2.setDescriptionText("Name of the field to capture must be defined");
        validationControlDecoration2.registerListener(24);
        this.fieldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = CaptureContextDialog.this.fieldButton.getSelection();
                CaptureContextDialog.this.fieldLabel.setVisible(bl);
                CaptureContextDialog.this.fieldText.setVisible(bl);
                CaptureContextDialog.this.fieldText.setEnabled(bl);
                CaptureContextDialog.this.fieldText.setFocus();
                CaptureContextDialog.this.fieldText.setSelection(0, CaptureContextDialog.this.fieldText.getText().length());
                validationControlDecoration2.executeValidation();
            }
        });
        this.createInfoLabel(composite2, "Select for capturing the field value on the object executing the method. Specify the correct name of the object field.");
        Label label2 = new Label(composite2, 0);
        label2.setText("Display name:");
        this.nameText = new Text(composite2, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.nameText.setFocus();
        ValidationControlDecoration<Text> validationControlDecoration3 = new ValidationControlDecoration<Text>(this.nameText, null, (IControlValidationListener)this){

            @Override
            protected boolean validate(Text text) {
                return StringUtils.isNotBlank((String)text.getText());
            }
        };
        validationControlDecoration3.setDescriptionText("Display name for this context capture must be defined");
        validationControlDecoration3.registerListener(24);
        this.createInfoLabel(composite2, "Display name defines how will the captured value be named.");
        Label label3 = new Label(composite2, 0);
        label3.setText("Accessor path:");
        this.accessorText = new Text(composite2, 2056);
        this.accessorText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.accessorText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                CaptureContextDialog.this.addPath.setFocus();
            }
        });
        this.addPath = new Button(composite2, 8);
        this.addPath.setText("Add Path");
        this.addPath.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                InputDialog inputDialog = new InputDialog(CaptureContextDialog.this.getShell(), "Path to Follow", "Enter field name to navigate on the captured object:", "", null);
                if (inputDialog.open() == 0 && StringUtils.isNotBlank((String)(string = inputDialog.getValue()))) {
                    CaptureContextDialog.this.paths.add(string);
                    CaptureContextDialog.this.updateAccessorText();
                }
            }
        });
        this.clearPaths = new Button(composite2, 8);
        this.clearPaths.setText("Clear All Paths");
        this.clearPaths.setLayoutData((Object)new GridData(4, 4, false, false));
        this.clearPaths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CaptureContextDialog.this.paths.clear();
                CaptureContextDialog.this.updateAccessorText();
            }
        });
        this.createInfoLabel(composite2, "Specify path to follow on the captured object. For example, if object of type Customer is captured, and this object has a field named 'id', then you can save the 'id' value by creating a path '-> id'. ");
        this.validationControlDecorations.add(validationControlDecoration);
        this.validationControlDecorations.add(validationControlDecoration2);
        this.validationControlDecorations.add(validationControlDecoration3);
        if (this.contextCapture != null) {
            this.nameText.setText(this.contextCapture.getDisplayName());
            if (CollectionUtils.isNotEmpty((Collection)this.contextCapture.getPaths())) {
                this.paths.addAll(this.contextCapture.getPaths());
                this.updateAccessorText();
            }
            if (this.contextCapture instanceof ParameterContextCapture) {
                this.indexText.setText(String.valueOf(((ParameterContextCapture)this.contextCapture).getIndex()));
            } else if (this.contextCapture instanceof FieldContextCapture) {
                this.fieldText.setText(((FieldContextCapture)this.contextCapture).getFieldName());
            }
        }
        return composite2;
    }

    private void updateAccessorText() {
        this.accessorText.setText("");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.paths) {
            stringBuilder.append(" -> ");
            stringBuilder.append(string);
        }
        this.accessorText.setText(stringBuilder.toString());
    }

    public AbstractContextCapture getContextCapture() {
        return this.contextCapture;
    }

    @Override
    public void validationStateChanged(boolean bl, ValidationControlDecoration<?> validationControlDecoration) {
        boolean bl2 = true;
        for (ValidationControlDecoration<?> validationControlDecoration2 : this.validationControlDecorations) {
            if (validationControlDecoration2.isValid()) continue;
            bl2 = false;
            break;
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(bl2);
        }
    }

    protected void createInfoLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setToolTipText(string);
        label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
    }
}

