/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import info.novatec.inspectit.minlog.MinlogToSLF4JLogger;
import info.novatec.inspectit.rcp.InspectITImages;
import info.novatec.inspectit.rcp.ci.InspectITConfigurationInterfaceManager;
import info.novatec.inspectit.rcp.log.LogListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryManager;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public class InspectIT
extends AbstractUIPlugin {
    public static final String ID = "info.novatec.inspectit.rcp";
    private static final String DEFAULT_LOG_FILE_NAME = "logging-config.xml";
    private static final String LOG_FILE_PROPERTY = "inspectit.logging.config";
    private static InspectIT plugin;
    private volatile CmrRepositoryManager cmrRepositoryManager;
    private volatile ScopedPreferenceStore preferenceStore;
    private volatile InspectITStorageManager storageManager;
    private volatile InspectITConfigurationInterfaceManager configurationInterfaceManager;
    private List<IPropertyChangeListener> propertyChangeListeners = new ArrayList<IPropertyChangeListener>();
    private Path runtimeDir;
    private ILogListener logListener;

    public void start(BundleContext bundleContext) throws Exception {
        plugin = this;
        this.locateRuntimeDir();
        this.initLogger();
        this.logListener = new LogListener();
        Platform.addLogListener((ILogListener)this.logListener);
        super.start(bundleContext);
    }

    private void locateRuntimeDir() {
        File file = null;
        try {
            file = FileLocator.getBundleFile((Bundle)this.getBundle());
        }
        catch (IOException iOException) {}
        this.runtimeDir = file != null && file.isDirectory() ? Paths.get(file.getAbsolutePath(), new String[0]) : Paths.get("", new String[0]);
    }

    private void initLogger() {
        LoggerContext loggerContext;
        block8: {
            loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext((Context)loggerContext);
            loggerContext.reset();
            InputStream inputStream = null;
            try {
                Path path;
                String string = System.getProperty(LOG_FILE_PROPERTY);
                if (string != null && Files.exists(path = Paths.get(string, new String[0]).toAbsolutePath(), new LinkOption[0])) {
                    inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                }
                if (inputStream == null && Files.exists(path = this.getRuntimeDir().resolve(DEFAULT_LOG_FILE_NAME).toAbsolutePath(), new LinkOption[0])) {
                    inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                }
                if (inputStream == null) break block8;
                try {
                    try {
                        joranConfigurator.doConfigure(inputStream);
                    }
                    catch (JoranException joranException) {
                        inputStream.close();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        MinlogToSLF4JLogger.init();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.cmrRepositoryManager != null) {
            this.cmrRepositoryManager.cancelAllUpdateRepositoriesJobs();
        }
        Platform.removeLogListener((ILogListener)this.logListener);
        this.logListener = null;
        super.stop(bundleContext);
        plugin = null;
    }

    public static InspectIT getDefault() {
        return plugin;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (!this.propertyChangeListeners.contains(iPropertyChangeListener)) {
            this.propertyChangeListeners.add(iPropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.remove(iPropertyChangeListener);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        for (IPropertyChangeListener iPropertyChangeListener : this.propertyChangeListeners) {
            iPropertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        Field[] fieldArray;
        Field[] fieldArray2 = fieldArray = InspectITImages.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getName().startsWith("IMG") && String.class.equals(field.getType())) {
                String string;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    string = (String)field.get(null);
                    URL uRL = this.getBundle().getEntry(string);
                    if (imageRegistry.get(string) == null) {
                        if (uRL != null) {
                            imageRegistry.put(string, ImageDescriptor.createFromURL((URL)uRL));
                            imageRegistry.get(string);
                        } else {
                            Status status = new Status(4, ID, "Image with the key '" + field.getName() + "' does not exist on the disk. ");
                            StatusManager.getManager().handle((IStatus)status, 3);
                        }
                    }
                }
                catch (Exception exception) {
                    string = new Status(4, ID, "Error loading image with the key'" + field.getName() + "'. ");
                    StatusManager.getManager().handle((IStatus)string, 3);
                }
            }
            ++n2;
        }
    }

    public Image getImage(String string) {
        return this.getImageRegistry().get(string);
    }

    public ImageDescriptor getImageDescriptor(String string) {
        return this.getImageRegistry().getDescriptor(string);
    }

    public static <E> E getService(Class<E> clazz) {
        ServiceReference serviceReference = InspectIT.getDefault().getBundle().getBundleContext().getServiceReference(clazz);
        if (serviceReference != null) {
            return (E)InspectIT.getDefault().getBundle().getBundleContext().getService(serviceReference);
        }
        throw new RuntimeException("Requested service of the class " + clazz.getName() + " is not registered in the bundle.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScopedPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            InspectIT inspectIT = this;
            synchronized (inspectIT) {
                if (this.preferenceStore == null) {
                    this.preferenceStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, ID);
                }
            }
        }
        return this.preferenceStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmrRepositoryManager getCmrRepositoryManager() {
        if (this.cmrRepositoryManager == null) {
            InspectIT inspectIT = this;
            synchronized (inspectIT) {
                if (this.cmrRepositoryManager == null) {
                    this.cmrRepositoryManager = new CmrRepositoryManager();
                }
            }
        }
        return this.cmrRepositoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InspectITStorageManager getInspectITStorageManager() {
        if (this.storageManager == null) {
            InspectIT inspectIT = this;
            synchronized (inspectIT) {
                if (this.storageManager == null) {
                    this.storageManager = InspectIT.getService(InspectITStorageManager.class);
                    this.storageManager.startUp();
                }
            }
        }
        return this.storageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InspectITConfigurationInterfaceManager getInspectITConfigurationInterfaceManager() {
        if (this.configurationInterfaceManager == null) {
            InspectIT inspectIT = this;
            synchronized (inspectIT) {
                if (this.configurationInterfaceManager == null) {
                    this.configurationInterfaceManager = InspectIT.getService(InspectITConfigurationInterfaceManager.class);
                }
            }
        }
        return this.configurationInterfaceManager;
    }

    public Path getRuntimeDir() {
        return this.runtimeDir;
    }

    public void setRuntimeDir(Path path) {
        this.runtimeDir = path;
    }

    public void createErrorDialog(String string, Throwable throwable, int n) {
        Status status = new Status(4, ID, n, string, throwable);
        StatusManager.getManager().handle((IStatus)status, 3);
    }

    public void createErrorDialog(String string, int n) {
        Status status = new Status(4, ID, n, string, null);
        StatusManager.getManager().handle((IStatus)status, 3);
    }

    public void createInfoDialog(String string, int n) {
        MessageDialog.openInformation(null, (String)"Information", (String)string);
    }

    public void log(int n, String string) {
        this.log(n, string, null);
    }

    public void log(int n, String string, Throwable throwable) {
        Status status = new Status(n, ID, 0, string, throwable);
        StatusManager.getManager().handle((IStatus)status, 1);
    }
}

