/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.storage;

import info.novatec.inspectit.cmr.dao.StorageDataDao;
import info.novatec.inspectit.cmr.storage.CmrStorageManager;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.IWriter;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageWriter;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import info.novatec.inspectit.storage.recording.RecordingState;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmrStorageRecorder {
    @Log
    Logger log;
    @Autowired
    CmrStorageManager cmrStorageManager;
    @Autowired
    StorageDataDao storageDataDao;
    @Autowired
    @Resource(name="scheduledExecutorService")
    ScheduledExecutorService executorService;
    private ScheduledFuture<?> stopRecordingFuture;
    private ScheduledFuture<?> startRecordingFuture;
    private Set<Long> involvedAgentsSet = new HashSet<Long>();
    private StorageWriter storageWriter;
    private RecordingProperties recordingProperties;
    private volatile RecordingState recordingState = RecordingState.OFF;

    public void record(DefaultData defaultData) {
        if (this.isRecordingOn() && this.storageWriter.isWritingOn()) {
            Collection recordingDataProcessors = this.recordingProperties.getRecordingDataProcessors();
            if (CollectionUtils.isNotEmpty((Collection)recordingDataProcessors)) {
                for (AbstractDataProcessor dataProcessor : recordingDataProcessors) {
                    dataProcessor.process(defaultData);
                }
            }
            this.involvedAgentsSet.add(defaultData.getPlatformIdent());
        }
    }

    public synchronized void startOrScheduleRecording(StorageWriter stWriter, RecordingProperties recProperties) throws IllegalArgumentException {
        if (!this.isRecordingOn() && !this.isRecordingScheduled()) {
            if (null == stWriter) {
                throw new IllegalArgumentException("Storage writer can not be null. Recording will not be started.");
            }
            if (!stWriter.isWritingOn()) {
                throw new IllegalArgumentException("Storage writer must be prepared for write. Recording will not be started.");
            }
            if (null == recProperties) {
                throw new IllegalArgumentException("Recording properties can not be null. Recording will not be started.");
            }
            if (CollectionUtils.isEmpty((Collection)recProperties.getRecordingDataProcessors())) {
                throw new IllegalArgumentException("Recording data processor must be provided for recording.");
            }
            this.storageWriter = stWriter;
            this.recordingProperties = recProperties;
            long startDelay = recProperties.getStartDelay();
            if (startDelay > 0L) {
                this.recordingState = RecordingState.SCHEDULED;
                Runnable startRecordingRunnable = new Runnable(){

                    @Override
                    public void run() {
                        CmrStorageRecorder.this.startRecording(CmrStorageRecorder.this.storageWriter, CmrStorageRecorder.this.recordingProperties);
                    }
                };
                this.startRecordingFuture = this.executorService.schedule(startRecordingRunnable, startDelay, TimeUnit.MILLISECONDS);
                Date recordStartDate = new Date(System.currentTimeMillis() + startDelay);
                this.recordingProperties.setRecordStartDate(recordStartDate);
            } else {
                this.startRecording(this.storageWriter, this.recordingProperties);
            }
        }
    }

    private synchronized void startRecording(StorageWriter stWriter, RecordingProperties recProperties) {
        if (!this.isRecordingOn()) {
            this.storageWriter = stWriter;
            this.recordingProperties = recProperties;
            Collection recordingDataProcessors = this.recordingProperties.getRecordingDataProcessors();
            if (null != recordingDataProcessors) {
                for (AbstractDataProcessor abstractDataProcessor : recordingDataProcessors) {
                    abstractDataProcessor.setStorageWriter((IWriter)this.storageWriter);
                }
            }
            this.recordingState = RecordingState.ON;
            this.recordingProperties.setRecordStartDate(new Date());
            long recordingDuration = this.recordingProperties.getRecordDuration();
            if (recordingDuration > 0L) {
                Runnable stopRecordingRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CmrStorageRecorder.this.cmrStorageManager.stopRecording();
                        }
                        catch (Exception e) {
                            CmrStorageRecorder.this.log.warn("Automatic stop of recording failed for the storage: " + CmrStorageRecorder.this.getStorageData(), (Throwable)e);
                        }
                    }
                };
                this.stopRecordingFuture = this.executorService.schedule(stopRecordingRunnable, recordingDuration, TimeUnit.MILLISECONDS);
                Date recordEndDate = new Date(System.currentTimeMillis() + recordingDuration);
                this.recordingProperties.setRecordEndDate(recordEndDate);
            }
            if (this.log.isDebugEnabled()) {
                this.log.info("Recording started for storage: " + this.getStorageData());
            }
        }
    }

    public synchronized void stopRecording() {
        if (this.isRecordingOn()) {
            Collection recordingDataProcessors;
            if (null != this.stopRecordingFuture) {
                if (!this.stopRecordingFuture.isDone() && !this.stopRecordingFuture.isCancelled()) {
                    this.stopRecordingFuture.cancel(false);
                }
                this.stopRecordingFuture = null;
            }
            if (null != (recordingDataProcessors = this.recordingProperties.getRecordingDataProcessors())) {
                for (AbstractDataProcessor abstractDataProcessor : recordingDataProcessors) {
                    abstractDataProcessor.flush();
                }
            }
            if (!this.involvedAgentsSet.isEmpty()) {
                List<SystemInformationData> toRecord = this.storageDataDao.getSystemInformationData(this.involvedAgentsSet);
                for (SystemInformationData defaultData : toRecord) {
                    this.record((DefaultData)defaultData);
                }
            }
            this.involvedAgentsSet.clear();
            if (this.log.isDebugEnabled()) {
                this.log.info("Recording stopped for storage: " + this.getStorageData());
            }
        } else if (this.isRecordingScheduled() && null != this.startRecordingFuture) {
            if (!this.startRecordingFuture.isDone() && !this.startRecordingFuture.isCancelled()) {
                this.startRecordingFuture.cancel(false);
            }
            this.startRecordingFuture = null;
        }
        this.storageWriter = null;
        this.recordingProperties = null;
        this.recordingState = RecordingState.OFF;
    }

    public boolean isRecordingOn() {
        return this.recordingState == RecordingState.ON;
    }

    public boolean isRecordingScheduled() {
        return this.recordingState == RecordingState.SCHEDULED;
    }

    protected StorageData getStorageData() {
        return this.storageWriter.getStorageData();
    }

    public RecordingState getRecordingState() {
        return this.recordingState;
    }

    public StorageWriter getStorageWriter() {
        return this.storageWriter;
    }

    public RecordingProperties getRecordingProperties() {
        return this.recordingProperties;
    }
}

