/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.spring.exporter;

import info.novatec.inspectit.cmr.service.ServiceExporterType;
import info.novatec.inspectit.cmr.service.ServiceInterface;
import info.novatec.inspectit.cmr.spring.exporter.KryoHttpInvokerServiceExporter;
import info.novatec.inspectit.cmr.spring.exporter.KryoNetRmiServiceExporter;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class RemotingExporter
implements BeanFactoryPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RemotingExporter.class);
    private Class<? extends Annotation> serviceAnnotationType = Service.class;
    private Class<? extends Annotation> serviceInterfaceAnnotationType = ServiceInterface.class;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        LOG.info("|-RemoteExporter: Processing Beans for remote export");
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            Class<?> serviceClass;
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (beanDef.isAbstract()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("|- RemoteExporter: Skipping abstract Bean '" + beanName + "'");
                continue;
            }
            if (null == beanDef.getBeanClassName()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("|- RemoteExporter: Skipping Bean '" + beanName + "' which has no bean class defined");
                continue;
            }
            Class<?> serviceInterface = null;
            String beanClassName = beanDef.getBeanClassName();
            if (null == beanClassName) continue;
            try {
                serviceClass = Class.forName(beanClassName);
                serviceInterface = this.findServiceInterface(serviceClass);
            }
            catch (ClassNotFoundException e) {
                throw new BeanCreationException("class of bean " + beanName + " not found", (Throwable)e);
            }
            if (serviceInterface != null) {
                RootBeanDefinition definition;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("|- RemoteExporter: Found service Bean with name '" + beanName + "' and interface " + serviceInterface);
                }
                Annotation annotation = AnnotationUtils.findAnnotation(serviceClass, this.serviceInterfaceAnnotationType);
                MutablePropertyValues values = new MutablePropertyValues();
                values.add("service", (Object)new RuntimeBeanReference(beanName));
                values.add("serviceInterface", (Object)new TypedStringValue(serviceInterface.getCanonicalName()));
                ServiceExporterType type = (ServiceExporterType)AnnotationUtils.getValue((Annotation)annotation, (String)"exporter");
                switch (type) {
                    case RMI: {
                        definition = new RootBeanDefinition(KryoNetRmiServiceExporter.class);
                        if (!this.annotationPropertySet(annotation, "serviceId")) break;
                        int serviceId = (Integer)AnnotationUtils.getValue((Annotation)annotation, (String)"serviceId");
                        values.add("serviceId", (Object)serviceId);
                        break;
                    }
                    case HTTP: {
                        definition = new RootBeanDefinition(KryoHttpInvokerServiceExporter.class);
                        break;
                    }
                    default: {
                        throw new BeanCreationException("Could not create service exporter bean because exporter type is not handled: " + type);
                    }
                }
                definition.setPropertyValues(values);
                definition.setAutowireCandidate(true);
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.registerBeanDefinition(this.getNameForExporterBean(beanName, annotation), (BeanDefinition)definition);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("|- RemoteExporter: Registered new Bean: " + beanName + "Exporter");
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("|- RemoteExporter: Skipping Bean because no remotable interface was found '" + beanName + "'");
        }
    }

    private boolean annotationPropertySet(Annotation annotation, String attributeName) {
        Object defaultValue = AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName);
        Object currentValue = AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        return !currentValue.equals(defaultValue);
    }

    private String getNameForExporterBean(String beanName, Annotation annotation) {
        String name = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"name");
        if (null != name && !"".equals(name.trim())) {
            return name;
        }
        return beanName + "Exporter";
    }

    private Class<?> findServiceInterface(Class<?> serviceClass) {
        Class<?> serviceInterface = null;
        if (AnnotationUtils.isAnnotationDeclaredLocally(this.serviceAnnotationType, serviceClass)) {
            for (Class<?> interfaceClass : serviceClass.getInterfaces()) {
                if (!AnnotationUtils.isAnnotationDeclaredLocally(this.serviceInterfaceAnnotationType, interfaceClass)) continue;
                serviceInterface = interfaceClass;
            }
        }
        return serviceInterface;
    }
}

