/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service.rest;

import info.novatec.inspectit.cmr.service.IStorageService;
import info.novatec.inspectit.cmr.service.rest.error.JsonError;
import info.novatec.inspectit.communication.data.ClassLoadingInformationData;
import info.novatec.inspectit.communication.data.CpuInformationData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.MemoryInformationData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.communication.data.ThreadInformationData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.communication.data.cmr.RecordingData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.SqlStatementDataAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.TimerDataAggregator;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.processor.impl.DataAggregatorProcessor;
import info.novatec.inspectit.storage.processor.impl.DataSaverProcessor;
import info.novatec.inspectit.storage.processor.impl.InvocationClonerDataProcessor;
import info.novatec.inspectit.storage.processor.impl.InvocationExtractorDataProcessor;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import info.novatec.inspectit.storage.recording.RecordingState;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/storage"})
public class StorageRestfulService {
    @Autowired
    IStorageService storageService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleAllException(Exception exception) {
        return new JsonError(exception).asModelAndView();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"all"})
    @ResponseBody
    public List<StorageData> getAllStorages() {
        List storages = this.storageService.getExistingStorages();
        return storages;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"get"})
    @ResponseBody
    public StorageData getStorageById(@RequestParam(value="id", required=true) String id) {
        List storages = this.storageService.getExistingStorages();
        for (StorageData storageData : storages) {
            if (!Objects.equals(id, storageData.getId())) continue;
            return storageData;
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"create"})
    @ResponseBody
    public Object createStorage(@RequestParam(value="name", required=true) String name) throws BusinessException {
        if (StringUtils.isEmpty((String)name)) {
            throw new BusinessException("Create a new storage via storage REST service.", (IErrorCode)StorageErrorCodeEnum.STORAGE_NAME_IS_NOT_PROVIDED);
        }
        StorageData storageData = new StorageData();
        storageData.setName(name);
        storageData = this.storageService.createAndOpenStorage(storageData);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("message", "Storage successfully created.");
        resultMap.put("storage", (String)storageData);
        return resultMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"finalize"})
    @ResponseBody
    public Object finalizeStorage(@RequestParam(value="id", required=true) String id) throws BusinessException {
        StorageData storageData = new StorageData();
        storageData.setId(id);
        this.storageService.closeStorage(storageData);
        return Collections.singletonMap("message", "Storage id " + id + " successfully finalized.");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"delete"})
    @ResponseBody
    public Object deleteStorage(@RequestParam(value="id", required=true) String id) throws BusinessException {
        StorageData storageData = new StorageData();
        storageData.setId(id);
        this.storageService.deleteStorage(storageData);
        return Collections.singletonMap("message", "Storage id " + id + " successfully deleted.");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"recording-state"})
    @ResponseBody
    public Map<String, Object> getRecordingState() {
        RecordingState state = this.storageService.getRecordingState();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("recordingState", state);
        if (RecordingState.OFF != state) {
            Date recordingEndDate;
            RecordingData recordingData = this.storageService.getRecordingData();
            resultMap.put("recordingStorage", recordingData.getRecordingStorage());
            if (RecordingState.ON == state && null != (recordingEndDate = recordingData.getRecordEndDate())) {
                resultMap.put("recordingStopDate", DateFormat.getDateTimeInstance().format(recordingEndDate));
            }
            if (RecordingState.SCHEDULED == state) {
                resultMap.put("schduledStartDate", DateFormat.getDateTimeInstance().format(recordingData.getRecordStartDate()));
            }
        }
        return resultMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"stop-recording"})
    @ResponseBody
    public Object stopRecording() throws BusinessException {
        this.storageService.stopRecording();
        return Collections.singletonMap("message", "Recording stopped.");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"start-recording"})
    @ResponseBody
    public Object startOrScheduleRecording(@RequestParam(value="id", required=true) String id, @RequestParam(value="startDelay", required=false) Long startDelay, @RequestParam(value="recordingDuration", required=false) Long recordingDuration, @RequestParam(value="extractInvocations", required=false, defaultValue="true") Boolean extractInvocations, @RequestParam(value="autoFinalize", required=false, defaultValue="true") Boolean autoFinalize) throws BusinessException {
        if (null == this.getStorageById(id)) {
            throw new BusinessException("Start or schedule recording on storage with ID=" + id + " via storage REST service.", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        StorageData storageData = new StorageData();
        storageData.setId(id);
        RecordingProperties recordingProperties = this.getRecordingProperties(extractInvocations);
        recordingProperties.setAutoFinalize(autoFinalize.booleanValue());
        if (null != startDelay && startDelay > 0L) {
            recordingProperties.setStartDelay(startDelay.longValue());
        }
        if (null != recordingDuration && recordingDuration > 0L) {
            recordingProperties.setRecordDuration(recordingDuration.longValue());
        }
        StorageData recordingStorage = this.storageService.startOrScheduleRecording(storageData, recordingProperties);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (recordingProperties.getStartDelay() > 0L) {
            resultMap.put("message", "Recording scheduled.");
        } else {
            resultMap.put("message", "Recording started.");
        }
        resultMap.put("recordingStorage", (String)recordingStorage);
        return resultMap;
    }

    private RecordingProperties getRecordingProperties(boolean extractInvocations) {
        RecordingProperties recordingProperties = new RecordingProperties();
        ArrayList<Object> normalProcessors = new ArrayList<Object>();
        ArrayList classesToSave = new ArrayList();
        Collections.addAll(classesToSave, InvocationSequenceData.class, HttpTimerData.class, ExceptionSensorData.class, MemoryInformationData.class, CpuInformationData.class, ClassLoadingInformationData.class, ThreadInformationData.class, SystemInformationData.class);
        DataSaverProcessor dataSaverProcessor = new DataSaverProcessor(classesToSave, true);
        normalProcessors.add(dataSaverProcessor);
        normalProcessors.add(new DataAggregatorProcessor(TimerData.class, 5000L, (IAggregator)new TimerDataAggregator(), true));
        normalProcessors.add(new DataAggregatorProcessor(SqlStatementData.class, 5000L, (IAggregator)new SqlStatementDataAggregator(true), true));
        if (extractInvocations) {
            ArrayList<Object> chainedProcessorsForExtractor = new ArrayList<Object>();
            chainedProcessorsForExtractor.addAll(normalProcessors);
            InvocationExtractorDataProcessor invocationExtractorDataProcessor = new InvocationExtractorDataProcessor(chainedProcessorsForExtractor);
            normalProcessors.add(invocationExtractorDataProcessor);
        }
        normalProcessors.add(new InvocationClonerDataProcessor());
        recordingProperties.setRecordingDataProcessors(normalProcessors);
        return recordingProperties;
    }
}

