/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.service.IServerStatusService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.version.VersionService;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerStatusService
implements IServerStatusService {
    @Log
    Logger log;
    @Autowired
    VersionService versionService;
    private IServerStatusService.ServerStatus status = IServerStatusService.ServerStatus.SERVER_STARTING;

    @MethodLog
    public IServerStatusService.ServerStatus getServerStatus() {
        return this.status;
    }

    @MethodLog
    public String getVersion() {
        return this.versionService.getVersionAsString();
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.status = IServerStatusService.ServerStatus.SERVER_ONLINE;
        this.status.setRegistrationIdsValidationKey(UUID.randomUUID().toString());
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Server Status Service active...");
        }
    }
}

