/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.DefaultDataDao;
import info.novatec.inspectit.cmr.dao.PlatformIdentDao;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.cmr.util.AgentStatusDataProvider;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.AgentManagementErrorCodeEnum;
import info.novatec.inspectit.spring.logger.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GlobalDataAccessService
implements IGlobalDataAccessService {
    @Log
    Logger log;
    @Autowired
    PlatformIdentDao platformIdentDao;
    @Autowired
    DefaultDataDao defaultDataDao;
    @Autowired
    AgentStatusDataProvider agentStatusProvider;

    @MethodLog
    public Map<PlatformIdent, AgentStatusData> getAgentsOverview() {
        List<PlatformIdent> agents = this.platformIdentDao.findAll();
        Map<Long, AgentStatusData> agentStatusMap = this.agentStatusProvider.getAgentStatusDataMap();
        HashMap<PlatformIdent, AgentStatusData> resultMap = new HashMap<PlatformIdent, AgentStatusData>();
        for (PlatformIdent platformIdent : agents) {
            resultMap.put(platformIdent, agentStatusMap.get(platformIdent.getId()));
        }
        return resultMap;
    }

    @MethodLog
    public PlatformIdent getCompleteAgent(long id) throws BusinessException {
        PlatformIdent platformIdent = this.platformIdentDao.findInitialized(id);
        if (null != platformIdent) {
            return platformIdent;
        }
        throw new BusinessException("Load the agent with ID=" + id + ".", (IErrorCode)AgentManagementErrorCodeEnum.AGENT_DOES_NOT_EXIST);
    }

    @MethodLog
    public void deleteAgent(long platformId) throws BusinessException {
        PlatformIdent platformIdent = this.platformIdentDao.load(platformId);
        if (null != platformIdent) {
            AgentStatusData agentStatusData = this.agentStatusProvider.getAgentStatusDataMap().get(platformIdent.getId());
            if (null != agentStatusData && agentStatusData.getAgentConnection() == AgentStatusData.AgentConnection.CONNECTED) {
                throw new BusinessException("Delete the agent '" + platformIdent.getAgentName() + "'.", (IErrorCode)AgentManagementErrorCodeEnum.AGENT_CAN_NOT_BE_DELETED);
            }
        } else {
            throw new BusinessException("Delete the agent with the ID=" + platformId + ".", (IErrorCode)AgentManagementErrorCodeEnum.AGENT_DOES_NOT_EXIST);
        }
        this.platformIdentDao.delete(platformIdent);
        this.defaultDataDao.deleteAll(platformIdent.getId());
        this.agentStatusProvider.registerDeleted(platformId);
        this.log.info("The Agent '" + platformIdent.getAgentName() + "' with the ID " + platformIdent.getId() + " was successfully deleted from the CMR.");
    }

    @MethodLog
    public List<DefaultData> getLastDataObjects(DefaultData template, long timeInterval) {
        List<DefaultData> result = this.defaultDataDao.findByExampleWithLastInterval(template, timeInterval);
        return result;
    }

    @MethodLog
    public DefaultData getLastDataObject(DefaultData template) {
        DefaultData result = this.defaultDataDao.findByExampleLastData(template);
        return result;
    }

    @MethodLog
    public List<? extends DefaultData> getDataObjectsFromToDate(DefaultData template, Date fromDate, Date toDate) {
        if (fromDate.after(toDate)) {
            return Collections.emptyList();
        }
        List<DefaultData> result = this.defaultDataDao.findByExampleFromToDate(template, fromDate, toDate);
        return result;
    }

    @MethodLog
    public List<? extends DefaultData> getTemplatesDataObjectsFromToDate(Collection<DefaultData> templates, Date fromDate, Date toDate) {
        if (fromDate.after(toDate)) {
            return Collections.emptyList();
        }
        ArrayList<? extends DefaultData> result = new ArrayList<DefaultData>();
        for (DefaultData template : templates) {
            result.addAll(this.getDataObjectsFromToDate(template, fromDate, toDate));
        }
        return result;
    }

    @MethodLog
    public List<DefaultData> getDataObjectsSinceId(DefaultData template) {
        List<DefaultData> result = this.defaultDataDao.findByExampleSinceId(template);
        return result;
    }

    @MethodLog
    public List<DefaultData> getDataObjectsSinceIdIgnoreMethodId(DefaultData template) {
        List<DefaultData> result = this.defaultDataDao.findByExampleSinceIdIgnoreMethodId(template);
        return result;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Global Data Access Service active...");
        }
    }
}

