/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.DefaultDataDao;
import info.novatec.inspectit.cmr.property.spring.PropertyUpdate;
import info.novatec.inspectit.cmr.service.IAgentStorageService;
import info.novatec.inspectit.cmr.service.ICmrManagementService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.cmr.util.AgentStatusDataProvider;
import info.novatec.inspectit.cmr.util.Converter;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.spring.logger.Log;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgentStorageService
implements IAgentStorageService {
    @Log
    Logger log;
    private static final int QUEUE_CAPACITY = 50;
    private static final long DATA_THROW_TIMEOUT_MILLIS = 10L;
    @Autowired
    private DefaultDataDao defaultDataDao;
    @Autowired
    AgentStatusDataProvider platformIdentDateSaver;
    @Autowired
    ICmrManagementService cmrManagementService;
    private ArrayBlockingQueue<SoftReference<List<? extends DefaultData>>> dataObjectsBlockingQueue = new ArrayBlockingQueue(50);
    @Value(value="${cmr.agentStorageServiceThreadCount}")
    private int threadCount;
    private List<Thread> threadList = new ArrayList<Thread>();

    public AgentStorageService() {
    }

    AgentStorageService(ArrayBlockingQueue<SoftReference<List<? extends DefaultData>>> dataObjectsBlockingQueue) {
        this.dataObjectsBlockingQueue = dataObjectsBlockingQueue;
    }

    @MethodLog
    public void addDataObjects(List<? extends DefaultData> dataObjects) {
        SoftReference<List<? extends DefaultData>> softReference = new SoftReference<List<? extends DefaultData>>(dataObjects);
        if (!dataObjects.isEmpty()) {
            this.platformIdentDateSaver.registerDataSent(dataObjects.get(0).getPlatformIdent());
        }
        try {
            boolean added = this.dataObjectsBlockingQueue.offer(softReference, 10L, TimeUnit.MILLISECONDS);
            if (!added) {
                int droppedSize = dataObjects.size();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Data dropped on the CMR due to the high volume of incoming data from Agent(s). Dropped data objects count: " + droppedSize);
                }
                this.cmrManagementService.addDroppedDataCount(droppedSize);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    @PropertyUpdate(properties={"cmr.agentStorageServiceThreadCount"})
    public synchronized void updateThreadCount() {
        block6: {
            int threadListSize;
            block5: {
                if (this.threadCount <= 0) {
                    this.threadCount = 1;
                }
                if (this.threadCount >= (threadListSize = this.threadList.size())) break block5;
                for (int i = 0; i < threadListSize - this.threadCount; ++i) {
                    Thread thread = this.threadList.remove(i);
                    thread.interrupt();
                    try {
                        thread.join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
                break block6;
            }
            if (this.threadCount <= threadListSize) break block6;
            for (int i = threadListSize; i < this.threadCount; ++i) {
                ProcessDataThread processDataThread = new ProcessDataThread(i);
                processDataThread.start();
                this.threadList.add(processDataThread);
            }
        }
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.updateThreadCount();
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Agent Storage Service active...");
        }
    }

    private class ProcessDataThread
    extends Thread {
        public ProcessDataThread(int threadId) {
            this.setName("agent-storage-service-process-data-thread-" + threadId);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                SoftReference softReference = null;
                try {
                    softReference = (SoftReference)AgentStorageService.this.dataObjectsBlockingQueue.take();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    return;
                }
                List defaultDataList = (List)softReference.get();
                if (defaultDataList == null) continue;
                for (DefaultData data : defaultDataList) {
                    data.finalizeData();
                }
                long time = 0L;
                if (AgentStorageService.this.log.isDebugEnabled()) {
                    time = System.nanoTime();
                }
                AgentStorageService.this.defaultDataDao.saveAll(defaultDataList);
                if (!AgentStorageService.this.log.isDebugEnabled()) continue;
                AgentStorageService.this.log.debug("Data Objects count: " + defaultDataList.size() + " Save duration: " + Converter.nanoToMilliseconds(System.nanoTime() - time));
            }
        }
    }
}

