/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.spring.PropertyUpdate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class PropertyUpdateExecutor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUpdateExecutor.class);
    private ConfigurableListableBeanFactory beanFactory;
    private List<PropertyUpdateFieldInfo> fieldInfoList = new ArrayList<PropertyUpdateFieldInfo>();
    private List<PropertyUpdateMethodInfo> methodInfoList = new ArrayList<PropertyUpdateMethodInfo>();

    public void executePropertyUpdates(List<SingleProperty<?>> properties) {
        for (SingleProperty<?> singleProperty : properties) {
            for (PropertyUpdateFieldInfo fieldInfo : this.fieldInfoList) {
                if (!fieldInfo.isPropertyMatching(singleProperty)) continue;
                Object value = singleProperty.getValue();
                if (!fieldInfo.getField().getType().equals(value.getClass())) {
                    value = this.beanFactory.getTypeConverter().convertIfNecessary(value, fieldInfo.getField().getType());
                }
                ReflectionUtils.setField((Field)fieldInfo.getField(), (Object)fieldInfo.getTarget(), (Object)value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Updated field " + fieldInfo.getField().getName() + " on object " + fieldInfo.getTarget() + " with value " + value + ". The field was updated because of the updated property " + fieldInfo.getProperty());
            }
        }
        HashSet<PropertyUpdateMethodInfo> methodsToExecute = new HashSet<PropertyUpdateMethodInfo>();
        for (PropertyUpdateMethodInfo methodInfo : this.methodInfoList) {
            if (methodsToExecute.contains(methodInfo) || !methodInfo.arePropertiesMatching(properties)) continue;
            methodsToExecute.add(methodInfo);
        }
        if (CollectionUtils.isNotEmpty(methodsToExecute)) {
            for (PropertyUpdateMethodInfo methodInfo : methodsToExecute) {
                ReflectionUtils.invokeMethod((Method)methodInfo.getMethod(), (Object)methodInfo.getTarget());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Invoked the method " + methodInfo.getMethod().toGenericString() + " on target object " + methodInfo.getTarget() + ". The method was invoked cause it defines the following properties of which at least one was updated: " + Arrays.toString(methodInfo.getProperties()));
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                PropertyUpdate propertyUpdate;
                if (method.isAnnotationPresent(PropertyUpdate.class) && ArrayUtils.isEmpty((Object[])method.getParameterTypes()) && ArrayUtils.isNotEmpty((Object[])(propertyUpdate = method.getAnnotation(PropertyUpdate.class)).properties())) {
                    ReflectionUtils.makeAccessible((Method)method);
                    PropertyUpdateMethodInfo methodInfo = new PropertyUpdateMethodInfo(bean, method, propertyUpdate.properties());
                    PropertyUpdateExecutor.this.methodInfoList.add(methodInfo);
                }
            }
        });
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.isAnnotationPresent(Value.class)) {
                    if (Modifier.isFinal(field.getModifiers())) {
                        LOG.warn("Field " + field.getName() + " of bean " + beanName + " defines @Value annotation, although it's declared as final. This field can not be updated if its property value is changed.");
                        return;
                    }
                    Value value = field.getAnnotation(Value.class);
                    String placeholder = value.value();
                    int startChar = placeholder.indexOf(123);
                    int endChar = placeholder.indexOf(125);
                    String property = startChar > 0 && endChar > startChar ? placeholder.substring(startChar + 1, endChar) : placeholder;
                    ReflectionUtils.makeAccessible((Field)field);
                    PropertyUpdateFieldInfo fieldInfo = new PropertyUpdateFieldInfo(bean, field, property);
                    PropertyUpdateExecutor.this.fieldInfoList.add(fieldInfo);
                }
            }
        });
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("PropertyUpdateExecutor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private static final class PropertyUpdateMethodInfo {
        private final Object target;
        private final Method method;
        private final String[] properties;

        public PropertyUpdateMethodInfo(Object target, Method method, String[] properties) {
            if (null == target) {
                throw new IllegalArgumentException("Target object can not be null.");
            }
            if (null == method) {
                throw new IllegalArgumentException("Method to invoke can not be null.");
            }
            if (ArrayUtils.isEmpty((Object[])properties)) {
                throw new IllegalArgumentException("Property array can not be empty.");
            }
            this.target = target;
            this.method = method;
            this.properties = properties;
        }

        public Object getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }

        public String[] getProperties() {
            return this.properties;
        }

        public boolean arePropertiesMatching(List<SingleProperty<?>> updatedProperties) {
            if (CollectionUtils.isNotEmpty(updatedProperties)) {
                for (SingleProperty<?> property : updatedProperties) {
                    if (!ArrayUtils.contains((Object[])this.properties, (Object)property.getLogicalName())) continue;
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.target == null ? 0 : System.identityHashCode(this.target));
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyUpdateMethodInfo other = (PropertyUpdateMethodInfo)obj;
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.target == null ? other.target != null : System.identityHashCode(this.target) != System.identityHashCode(other.target));
        }
    }

    private static final class PropertyUpdateFieldInfo {
        private final Object target;
        private final Field field;
        private final String property;

        public PropertyUpdateFieldInfo(Object target, Field field, String property) {
            if (null == target) {
                throw new IllegalArgumentException("Target object can not be null.");
            }
            if (null == field) {
                throw new IllegalArgumentException("Field to update can not be null.");
            }
            if (null == property) {
                throw new IllegalArgumentException("Property name can not be null.");
            }
            this.target = target;
            this.field = field;
            this.property = property;
        }

        public Object getTarget() {
            return this.target;
        }

        public Field getField() {
            return this.field;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean isPropertyMatching(SingleProperty<?> updatedProperty) {
            return this.property.equals(updatedProperty.getLogicalName());
        }
    }
}

