/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.jetty;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;

public class FileUploadServlet
extends HttpServlet
implements InitializingBean {
    private static final long serialVersionUID = 5619516365594064035L;
    private static final String MULTI_PART_FILTER_FILES = "org.mortbay.servlet.MultiPartFilter.files";
    private String directoryToStore;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List files = (List)req.getAttribute(MULTI_PART_FILTER_FILES);
        if (null != files) {
            for (int i = 0; i < files.size(); ++i) {
                File outputFile;
                File file = (File)files.get(i);
                StringBuilder nameBuffer = new StringBuilder();
                nameBuffer.append(this.directoryToStore);
                nameBuffer.append(File.separatorChar);
                Enumeration attributeNames = req.getAttributeNames();
                while (attributeNames.hasMoreElements()) {
                    String fileName = (String)attributeNames.nextElement();
                    if (!Objects.equals(file, req.getAttribute(fileName))) continue;
                    nameBuffer.append(fileName);
                    break;
                }
                if ((outputFile = new File(nameBuffer.toString())).exists()) {
                    throw new IOException("Upload file already exists. Aborting the upload.");
                }
                File outputDir = outputFile.getParentFile();
                if (null != outputDir && !outputDir.exists() && !outputDir.mkdirs()) {
                    throw new IOException("Needed directory " + outputDir + " can not be created.");
                }
                if (file.renameTo(outputFile)) continue;
                throw new IOException("Temporary file " + file + " can not be renamed to the correct upload file name " + outputFile + ".");
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void setDirectoryToStore(String directoryToStore) {
        this.directoryToStore = directoryToStore;
    }

    public void afterPropertiesSet() throws Exception {
        Files.createDirectories(Paths.get(this.directoryToStore, new String[0]), new FileAttribute[0]);
    }
}

