/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.indexing.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.buffer.IBufferBranchIndexer;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import info.novatec.inspectit.indexing.buffer.impl.Branch;
import info.novatec.inspectit.indexing.buffer.impl.BufferBranchIndexer;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.indexing.indexer.IBranchIndexer;
import info.novatec.inspectit.indexing.indexer.impl.ObjectTypeIndexer;
import info.novatec.inspectit.indexing.indexer.impl.PlatformIdentIndexer;
import info.novatec.inspectit.indexing.indexer.impl.TimestampIndexer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.stereotype.Component;

@Component
public class RootBranchFactory
implements FactoryBean<RootBranch<DefaultData>> {
    public RootBranch<DefaultData> getObject() throws Exception {
        BufferBranchIndexer timestampIndexer = new BufferBranchIndexer((IBranchIndexer)new TimestampIndexer());
        BufferBranchIndexer objectTypeIndexer = new BufferBranchIndexer((IBranchIndexer)new ObjectTypeIndexer(), timestampIndexer);
        BufferBranchIndexer platformIndexer = new BufferBranchIndexer((IBranchIndexer)new PlatformIdentIndexer(), objectTypeIndexer);
        return new RootBranch<DefaultData>((IBufferBranchIndexer<DefaultData>)platformIndexer);
    }

    public Class<?> getObjectType() {
        return IBufferTreeComponent.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static class RootBranch<E extends DefaultData>
    extends Branch<E> {
        private Runnable clearEmptyComponentsRunnable = new Runnable(){

            @Override
            public void run() {
                RootBranch.this.clearEmptyComponents();
            }
        };
        private Future<?> clearEmptyComponentsFuture;

        public RootBranch(IBufferBranchIndexer<E> branchIndexer) {
            super(branchIndexer);
        }

        public E put(E element) throws IndexingException {
            if (null == element) {
                throw new IndexingException("Null object can not be indexed.");
            }
            return (E)((DefaultData)super.put(element));
        }

        public void cleanWithRunnable(ExecutorService executorService) {
            super.cleanWithRunnable(executorService);
            if (this.clearEmptyComponentsFuture == null || this.clearEmptyComponentsFuture.isDone()) {
                this.clearEmptyComponentsFuture = executorService.submit(this.clearEmptyComponentsRunnable);
            }
        }
    }
}

