/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.cmr.cache.impl.ObjectSizes32Bits;
import info.novatec.inspectit.cmr.cache.impl.ObjectSizes32BitsIbm;
import info.novatec.inspectit.cmr.cache.impl.ObjectSizes64Bits;
import info.novatec.inspectit.cmr.cache.impl.ObjectSizes64BitsCompressedOops;
import info.novatec.inspectit.cmr.cache.impl.ObjectSizes64BitsCompressedOopsIbm;
import info.novatec.inspectit.cmr.cache.impl.ObjectSizes64BitsIbm;
import info.novatec.inspectit.util.UnderlyingSystemInfo;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.stereotype.Component;

@Component
public class ObjectSizesFactory
implements FactoryBean<IObjectSizes> {
    public IObjectSizes getObject() throws Exception {
        boolean isIbm = UnderlyingSystemInfo.JVM_PROVIDER == UnderlyingSystemInfo.JvmProvider.IBM;
        boolean is64Bit = UnderlyingSystemInfo.IS_64BIT;
        boolean compresedOops = UnderlyingSystemInfo.IS_COMPRESSED_OOPS;
        if (is64Bit && !compresedOops) {
            if (isIbm) {
                return new ObjectSizes64BitsIbm();
            }
            return new ObjectSizes64Bits();
        }
        if (is64Bit && compresedOops) {
            if (isIbm) {
                return new ObjectSizes64BitsCompressedOopsIbm();
            }
            return new ObjectSizes64BitsCompressedOops();
        }
        if (isIbm) {
            return new ObjectSizes32BitsIbm();
        }
        return new ObjectSizes32Bits();
    }

    public Class<IObjectSizes> getObjectType() {
        return IObjectSizes.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

