/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.cmr.cache.IBufferElement;
import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;

public class BufferElement<E extends DefaultData>
implements IBufferElement<E> {
    private IBufferElement<E> nextElement;
    private E object;
    private long bufferElementSize;
    private IBufferElement.BufferElementState bufferElementState;

    public BufferElement(E object) {
        this.object = object;
        this.bufferElementState = IBufferElement.BufferElementState.INSERTED;
    }

    @Override
    public E getObject() {
        return this.object;
    }

    @Override
    public long getBufferElementSize() {
        return this.bufferElementSize;
    }

    @Override
    public void setBufferElementSize(long size) {
        this.bufferElementSize = size;
    }

    @Override
    public IBufferElement<E> getNextElement() {
        return this.nextElement;
    }

    @Override
    public void setNextElement(IBufferElement<E> element) {
        this.nextElement = element;
    }

    @Override
    public void calculateAndSetBufferElementSize(IObjectSizes objectSizes) {
        long size = objectSizes.getSizeOfObjectHeader() + objectSizes.getPrimitiveTypesSize(2, 0, 0, 0, 1, 0);
        if (null != this.object) {
            size += this.object.getObjectSize(objectSizes);
        }
        this.bufferElementSize = size = (long)((float)size + (float)size * objectSizes.getObjectSecurityExpansionRate());
    }

    @Override
    public boolean isAnalyzed() {
        return this.bufferElementState.compareTo(IBufferElement.BufferElementState.ANALYZED) >= 0;
    }

    @Override
    public boolean isEvicted() {
        return this.bufferElementState.compareTo(IBufferElement.BufferElementState.EVICTED) >= 0;
    }

    @Override
    public boolean isIndexed() {
        return this.bufferElementState.compareTo(IBufferElement.BufferElementState.INDEXED) >= 0;
    }

    @Override
    public IBufferElement.BufferElementState getBufferElementState() {
        return this.bufferElementState;
    }

    @Override
    public void setBufferElementState(IBufferElement.BufferElementState bufferElementState) {
        this.bufferElementState = bufferElementState;
    }
}

