/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.util;

import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.util.DeleteFileVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.lang.ArrayUtils;

public class StorageDeleteFileVisitor
extends DeleteFileVisitor {
    private StorageFileType[] storageFileTypes;
    private boolean deleteDirs;

    public StorageDeleteFileVisitor(StorageFileType[] storageFileTypes, boolean deleteDirs) {
        this.storageFileTypes = storageFileTypes;
        this.deleteDirs = deleteDirs;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (ArrayUtils.isNotEmpty((Object[])this.storageFileTypes)) {
            for (StorageFileType storageFileType : this.storageFileTypes) {
                if (!file.endsWith(storageFileType.getExtension())) continue;
                return super.visitFile(file, attrs);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (this.deleteDirs) {
            try {
                return super.postVisitDirectory(dir, exc);
            }
            catch (IOException e) {
                return FileVisitResult.CONTINUE;
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

