/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.util;

import info.novatec.inspectit.storage.util.DeleteFileVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class CopyMoveFileVisitor
extends DeleteFileVisitor {
    private Path fromPath;
    private Path toPath;
    private boolean deleteSource;

    public CopyMoveFileVisitor(Path fromPath, Path toPath) {
        this(fromPath, toPath, false);
    }

    public CopyMoveFileVisitor(Path fromPath, Path toPath, boolean deleteSource) {
        this.fromPath = fromPath;
        this.toPath = toPath;
        this.deleteSource = deleteSource;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (this.deleteSource) {
            return super.postVisitDirectory(dir, exc);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        if (this.deleteSource) {
            return super.visitFile(file, attrs);
        }
        return FileVisitResult.CONTINUE;
    }
}

