/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.processor.write.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.StorageWriter;
import info.novatec.inspectit.storage.processor.write.AbstractWriteDataProcessor;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QueryCachingDataProcessor<E extends DefaultData>
extends AbstractWriteDataProcessor {
    private IIndexQuery query;
    private IAggregator<E> aggregator;
    private ConcurrentHashMap<Long, AggregationPerformer<E>> aggregationPerformerMap;

    public QueryCachingDataProcessor(IIndexQuery query, IAggregator<E> aggregator) {
        this.query = query;
        this.aggregator = aggregator;
        this.aggregationPerformerMap = new ConcurrentHashMap(4, 0.75f, 1);
    }

    @Override
    protected void processData(DefaultData defaultData, Map<?, ?> kryoPreferences) {
        Long key = defaultData.getPlatformIdent();
        AggregationPerformer<DefaultData> aggregationPerformer = this.aggregationPerformerMap.get(key);
        if (null == aggregationPerformer && null == (aggregationPerformer = this.aggregationPerformerMap.putIfAbsent(key, new AggregationPerformer<E>(this.aggregator)))) {
            aggregationPerformer = this.aggregationPerformerMap.get(key);
        }
        if (Boolean.FALSE.equals(kryoPreferences.get("WRITE_INVOCATION_AFFILIATION_DATA")) && defaultData instanceof InvocationAwareData) {
            InvocationAwareData invocationAwareData = (InvocationAwareData)defaultData;
            Map temp = invocationAwareData.getInvocationsParentsIdMap();
            invocationAwareData.setInvocationsParentsIdMap(Collections.emptyMap());
            aggregationPerformer.processElement(defaultData);
            invocationAwareData.setInvocationsParentsIdMap(temp);
        } else {
            aggregationPerformer.processElement(defaultData);
        }
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        return defaultData.isQueryComplied(this.query);
    }

    @Override
    public void onFinalization(StorageManager storageManager, StorageWriter storageWriter, StorageData storageData) throws Exception {
        for (Map.Entry<Long, AggregationPerformer<E>> entry : this.aggregationPerformerMap.entrySet()) {
            this.query.setPlatformIdent(entry.getKey().longValue());
            AggregationPerformer<E> aggregationPerformer = entry.getValue();
            storageManager.cacheStorageData(storageData, aggregationPerformer.getResultList(), storageManager.getCachedDataHash(this.query, this.aggregator));
        }
    }
}

