/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.processor.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.storage.processor.AbstractChainedDataProcessor;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TimeFrameDataProcessor
extends AbstractChainedDataProcessor {
    private static final long serialVersionUID = -787983119053084482L;
    private Date fromDate;
    private Date toDate;

    public TimeFrameDataProcessor() {
        super(Collections.emptyList());
    }

    public TimeFrameDataProcessor(Date fromDate, Date toDate, List<AbstractDataProcessor> dataProcessors) {
        super(dataProcessors);
        if (null != fromDate && null != toDate && fromDate.after(toDate)) {
            throw new IllegalArgumentException("Time frame not specified correctly. From date (" + fromDate + ") is after to date (" + toDate + ") value.");
        }
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        return true;
    }

    @Override
    protected boolean shouldBePassedToChainedProcessors(DefaultData defaultData) {
        return this.isInTimeframe(defaultData);
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    private boolean isInTimeframe(DefaultData defaultData) {
        if (null != this.fromDate && this.fromDate.after(defaultData.getTimeStamp())) {
            return false;
        }
        return null == this.toDate || !this.toDate.before(defaultData.getTimeStamp());
    }
}

