/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.processor.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.IIdsAwareAggregatedData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;

public class DataAggregatorProcessor<E extends TimerData>
extends AbstractDataProcessor {
    private static final long serialVersionUID = -883029940157040641L;
    private static final int DEFAULT_MAX_ELEMENTS = 200;
    private long aggregationPeriod;
    private int maxElements;
    private AtomicInteger elementCount = new AtomicInteger(0);
    private ConcurrentHashMap<Integer, IAggregatedData<E>> map = new ConcurrentHashMap(64, 0.75f, 4);
    private ConcurrentLinkedQueue<IAggregatedData<E>> queue = new ConcurrentLinkedQueue();
    private Class<E> clazz;
    private IAggregator<E> dataAggregator;
    private boolean writeInvocationAffiliation;

    public DataAggregatorProcessor() {
    }

    public DataAggregatorProcessor(Class<E> clazz, long aggregationPeriod, IAggregator<E> dataAggregator, boolean writeInvocationAffiliation) {
        this(clazz, aggregationPeriod, 200, dataAggregator, writeInvocationAffiliation);
    }

    public DataAggregatorProcessor(Class<E> clazz, long aggregationPeriod, int maxElements, IAggregator<E> dataAggregator, boolean writeInvocationAffiliation) {
        if (null == clazz) {
            throw new IllegalArgumentException("Aggregation class can not be null.");
        }
        if (aggregationPeriod <= 0L) {
            throw new IllegalArgumentException("Aggregation period must be a positive number greater than zero.");
        }
        if (maxElements <= 0) {
            throw new IllegalArgumentException("Max elements must be a positive number greater than zero.");
        }
        if (null == dataAggregator) {
            throw new IllegalArgumentException("Aggregator can not be null.");
        }
        this.clazz = clazz;
        this.aggregationPeriod = aggregationPeriod;
        this.maxElements = maxElements;
        this.dataAggregator = dataAggregator;
        this.clazz = clazz;
        this.writeInvocationAffiliation = writeInvocationAffiliation;
    }

    @Override
    protected Collection<Future<Void>> processData(DefaultData defaultData) {
        TimerData timerData = (TimerData)defaultData;
        long alteredTimestamp = this.getAlteredTimestamp(timerData);
        int cacheHash = this.getCacheHash(timerData, alteredTimestamp);
        Object aggData = this.map.get(cacheHash);
        if (null == aggData) {
            aggData = this.clone(timerData, alteredTimestamp);
            IAggregatedData<E> insertedData = this.map.putIfAbsent(cacheHash, (IAggregatedData<E>)aggData);
            if (null == insertedData) {
                this.queue.add((IAggregatedData<IAggregatedData<E>>)aggData);
                int count = this.elementCount.incrementAndGet();
                if (this.maxElements < count) {
                    this.writeOldest();
                }
            } else {
                aggData = insertedData;
            }
        }
        this.dataAggregator.aggregate((IAggregatedData<TimerData>)aggData, timerData);
        return Collections.emptyList();
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        if (null != defaultData) {
            return this.clazz.equals(defaultData.getClass());
        }
        return false;
    }

    private void writeOldest() {
        IAggregatedData<E> oldest = this.queue.poll();
        TimerData data = (TimerData)oldest.getData();
        this.map.remove(this.getCacheHash(data, data.getTimeStamp().getTime()));
        data.finalizeData();
        this.elementCount.decrementAndGet();
        this.passToStorageWriter(data);
    }

    @Override
    public Collection<Future<Void>> flush() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        IAggregatedData<E> oldest = this.queue.poll();
        while (null != oldest) {
            TimerData data = (TimerData)oldest.getData();
            this.map.remove(this.getCacheHash(data, data.getTimeStamp().getTime()));
            data.finalizeData();
            this.elementCount.decrementAndGet();
            Future<Void> future = this.passToStorageWriter(data);
            CollectionUtils.addIgnoreNull(futures, future);
            oldest = this.queue.poll();
        }
        return futures;
    }

    private Future<Void> passToStorageWriter(E data) {
        if (data instanceof IIdsAwareAggregatedData) {
            ((IIdsAwareAggregatedData)data).clearAggregatedIds();
        }
        if (!this.writeInvocationAffiliation) {
            HashMap<String, Boolean> kryoPreferences = new HashMap<String, Boolean>(1);
            kryoPreferences.put("WRITE_INVOCATION_AFFILIATION_DATA", Boolean.FALSE);
            return this.getStorageWriter().write((DefaultData)data, (Map<?, ?>)kryoPreferences);
        }
        return this.getStorageWriter().write((DefaultData)data);
    }

    private int getCacheHash(E timerData, long timestampValue) {
        int prime = 31;
        Object key = this.dataAggregator.getAggregationKey(timerData);
        int result = key.hashCode();
        result = 31 * result + (int)(timestampValue ^ timestampValue >>> 32);
        return result;
    }

    private long getAlteredTimestamp(TimerData timerData) {
        long timestampValue = timerData.getTimeStamp().getTime();
        long newTimestampValue = timestampValue - timestampValue % this.aggregationPeriod;
        return newTimestampValue;
    }

    private IAggregatedData<E> clone(E timerData, long alteredTimestamp) {
        IAggregatedData<E> clone = this.dataAggregator.getClone(timerData);
        ((TimerData)clone.getData()).setId(timerData.getId());
        ((TimerData)clone.getData()).setTimeStamp(new Timestamp(alteredTimestamp));
        return clone;
    }
}

