/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.label;

import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import javax.persistence.Entity;
import javax.validation.constraints.NotNull;

@Entity
public class StringStorageLabel
extends AbstractStorageLabel<String> {
    private static final long serialVersionUID = -879178622863569380L;
    @NotNull
    private String stringValue;

    public StringStorageLabel() {
    }

    public StringStorageLabel(String stringValue, AbstractStorageLabelType<String> storageLabelType) {
        super(storageLabelType);
        this.stringValue = stringValue;
    }

    @Override
    public String getValue() {
        return this.stringValue;
    }

    @Override
    public void setValue(String value) {
        this.stringValue = value;
    }

    @Override
    public String getFormatedValue() {
        return this.stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringStorageLabel other = (StringStorageLabel)obj;
        return !(this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue));
    }

    @Override
    public int compareTo(AbstractStorageLabel<?> other) {
        int typeCompare = this.storageLabelType.compareTo(other.getStorageLabelType());
        if (0 != typeCompare) {
            return typeCompare;
        }
        if (!StringStorageLabel.class.isAssignableFrom(other.getClass())) {
            return super.compareTo(other);
        }
        StringStorageLabel otherLabel = (StringStorageLabel)other;
        return this.stringValue.compareToIgnoreCase(otherLabel.stringValue);
    }
}

