/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.label;

import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.text.NumberFormat;
import javax.persistence.Entity;
import javax.validation.constraints.NotNull;

@Entity
public class NumberStorageLabel
extends AbstractStorageLabel<Number> {
    private static final long serialVersionUID = 7550228008433561954L;
    @NotNull
    private Number numberValue;

    public NumberStorageLabel() {
    }

    public NumberStorageLabel(Number numberValue, AbstractStorageLabelType<Number> storageLabelType) {
        super(storageLabelType);
        this.numberValue = numberValue;
    }

    @Override
    public Number getValue() {
        return this.numberValue;
    }

    @Override
    public void setValue(Number value) {
        this.numberValue = value;
    }

    @Override
    public String getFormatedValue() {
        return NumberFormat.getInstance().format(this.numberValue);
    }

    public Number getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(Number numberValue) {
        this.numberValue = numberValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.numberValue == null ? 0 : this.numberValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberStorageLabel other = (NumberStorageLabel)obj;
        return !(this.numberValue == null ? other.numberValue != null : !this.numberValue.equals(other.numberValue));
    }

    @Override
    public int compareTo(AbstractStorageLabel<?> other) {
        int typeCompare = this.storageLabelType.compareTo(other.getStorageLabelType());
        if (0 != typeCompare) {
            return typeCompare;
        }
        if (!NumberStorageLabel.class.isAssignableFrom(other.getClass())) {
            return super.compareTo(other);
        }
        NumberStorageLabel otherLabel = (NumberStorageLabel)other;
        double res = this.numberValue.doubleValue() - otherLabel.numberValue.doubleValue();
        if (res > 0.0) {
            return 1;
        }
        if (res < 0.0) {
            return -1;
        }
        return 0;
    }
}

