/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.StorageWriter;
import info.novatec.inspectit.storage.util.StorageIndexTreeProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Lazy
public class StorageIndexingTreeHandler {
    @Log
    Logger log;
    private static final long WAITING_FOR_TREE_TO_BE_READY = 1000L;
    private static final int FINISH_WAITING_ITERATIONS = 30;
    private static final long TREE_CHECK_DELAY = 30L;
    private static final TimeUnit TREE_CHECK_DELAY_TIME_UNIT = TimeUnit.SECONDS;
    private StorageWriter storageWriter;
    @Autowired
    StorageIndexTreeProvider<DefaultData> storageIndexTreeProvider;
    @Autowired
    @Resource(name="scheduledExecutorService")
    ScheduledExecutorService executorService;
    private AtomicReference<IStorageTreeComponent<DefaultData>> storageIndexingTreeReference;
    private Map<StorageWriter.WriteTask, TreeDescriptorPair> writeTasksInProcess = new ConcurrentHashMap<StorageWriter.WriteTask, TreeDescriptorPair>(16, 0.75f, 2);
    @Autowired
    IObjectSizes objectSizes;
    @Value(value="${storage.maximumIndexingTreeSize}")
    long maximumIndexingTreeSize;
    private volatile ScheduledFuture<?> indexingTreeSavingFuture;

    public void prepare() {
        this.storageIndexingTreeReference = new AtomicReference<IStorageTreeComponent<DefaultData>>(this.getNewStorageIndexingTree());
        this.indexingTreeSavingFuture = this.executorService.scheduleWithFixedDelay(new IndexingTreeSavingTask(), 30L, 30L, TREE_CHECK_DELAY_TIME_UNIT);
    }

    public int startWrite(StorageWriter.WriteTask writeTask) throws IndexingException {
        DefaultData data = writeTask.getData();
        if (null == data) {
            throw new IndexingException("Indexing failed. Data to index was null.");
        }
        TreeDescriptorPair treeDescriptorPair = new TreeDescriptorPair();
        this.writeTasksInProcess.put(writeTask, treeDescriptorPair);
        IStorageTreeComponent<DefaultData> indexingTree = this.storageIndexingTreeReference.get();
        IStorageDescriptor storageDescriptor = (IStorageDescriptor)indexingTree.put(data);
        if (null == storageDescriptor) {
            throw new IndexingException("Indexing failed. Storage descriptor was null.");
        }
        treeDescriptorPair.setIndexingTree(indexingTree);
        treeDescriptorPair.setStorageDescriptor(storageDescriptor);
        return storageDescriptor.getChannelId();
    }

    public void writeSuccessful(StorageWriter.WriteTask writeTask, long position, long size) {
        IStorageDescriptor storageDescriptor;
        TreeDescriptorPair treeDescriptorPair = this.writeTasksInProcess.get(writeTask);
        if (null != treeDescriptorPair && null != (storageDescriptor = treeDescriptorPair.getStorageDescriptor())) {
            storageDescriptor.setPositionAndSize(position, size);
        }
        this.writeTasksInProcess.remove(writeTask);
    }

    public void writeFailed(StorageWriter.WriteTask writeTask) {
        IStorageTreeComponent<DefaultData> indexingTree;
        TreeDescriptorPair treeDescriptorPair = this.writeTasksInProcess.get(writeTask);
        if (null != treeDescriptorPair && null != (indexingTree = treeDescriptorPair.getIndexingTree())) {
            indexingTree.getAndRemove(writeTask.getData());
        }
        this.writeTasksInProcess.remove(writeTask);
    }

    public void cancelIndexingTreeSavingFuture() {
        if (!this.indexingTreeSavingFuture.isDone() && !this.indexingTreeSavingFuture.isCancelled()) {
            this.indexingTreeSavingFuture.cancel(false);
        }
    }

    public void finish() {
        this.cancelIndexingTreeSavingFuture();
        IStorageTreeComponent<DefaultData> currentIndexingTree = null;
        while (!this.storageIndexingTreeReference.compareAndSet(currentIndexingTree = this.storageIndexingTreeReference.get(), null)) {
        }
        if (null != currentIndexingTree) {
            int sleepCount = 0;
            while (!this.writeTasksInProcess.isEmpty()) {
                this.log.info("Indexing tree handler still waiting for " + this.writeTasksInProcess.size() + " task(s) to be finished. Going for sleep " + (sleepCount + 1) + " out of " + 30 + ".");
                if (sleepCount > 30) {
                    this.log.warn("Indexing tree handler waited " + (long)sleepCount * 1000L + " milliseconds for all tasks to be finished. There are " + this.writeTasksInProcess.size() + " tasks still in-progress. Saving of the indexing tree will continue without waiting for these tasks.");
                    break;
                }
                try {
                    Thread.sleep(1000L);
                    ++sleepCount;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            currentIndexingTree.preWriteFinalization();
            boolean written = this.storageWriter.writeNonDefaultDataObject(currentIndexingTree, this.getRandomFileName() + StorageFileType.INDEX_FILE.getExtension());
            if (!written) {
                this.log.error("Indexing tree saving failed. Indexing tree might be lost.");
            }
        }
    }

    int getWriteTaskInProgressCount() {
        return this.writeTasksInProcess.size();
    }

    private String getRandomFileName() {
        return UUID.randomUUID().toString();
    }

    private IStorageTreeComponent<DefaultData> getNewStorageIndexingTree() {
        return this.storageIndexTreeProvider.getStorageIndexingTree();
    }

    public void registerStorageWriter(StorageWriter storageWriter) {
        this.storageWriter = storageWriter;
    }

    private static final class TreeDescriptorPair {
        private IStorageDescriptor storageDescriptor;
        private IStorageTreeComponent<DefaultData> indexingTree;

        private TreeDescriptorPair() {
        }

        public IStorageDescriptor getStorageDescriptor() {
            return this.storageDescriptor;
        }

        public void setStorageDescriptor(IStorageDescriptor storageDescriptor) {
            this.storageDescriptor = storageDescriptor;
        }

        public IStorageTreeComponent<DefaultData> getIndexingTree() {
            return this.indexingTree;
        }

        public void setIndexingTree(IStorageTreeComponent<DefaultData> indexingTree) {
            this.indexingTree = indexingTree;
        }
    }

    class IndexingTreeSavingTask
    implements Runnable {
        IndexingTreeSavingTask() {
        }

        @Override
        public void run() {
            try {
                long treeSize;
                IStorageTreeComponent currentIndexingTree;
                while (null != (currentIndexingTree = (IStorageTreeComponent)StorageIndexingTreeHandler.this.storageIndexingTreeReference.get()) && (treeSize = currentIndexingTree.getComponentSize(StorageIndexingTreeHandler.this.objectSizes)) > StorageIndexingTreeHandler.this.maximumIndexingTreeSize) {
                    IStorageTreeComponent newIndexingTree = StorageIndexingTreeHandler.this.getNewStorageIndexingTree();
                    if (!StorageIndexingTreeHandler.this.storageIndexingTreeReference.compareAndSet(currentIndexingTree, newIndexingTree)) continue;
                    final HashSet writeTasksToWait = new HashSet(StorageIndexingTreeHandler.this.writeTasksInProcess.keySet());
                    Runnable writeOldIndexingTree = new Runnable(){

                        @Override
                        public void run() {
                            boolean safeToSave = Collections.disjoint(writeTasksToWait, StorageIndexingTreeHandler.this.writeTasksInProcess.keySet());
                            if (safeToSave) {
                                currentIndexingTree.preWriteFinalization();
                                boolean written = StorageIndexingTreeHandler.this.storageWriter.writeNonDefaultDataObject(currentIndexingTree, StorageIndexingTreeHandler.this.getRandomFileName() + StorageFileType.INDEX_FILE.getExtension());
                                if (!written) {
                                    StorageIndexingTreeHandler.this.log.error("Indexing tree saving failed. Indexing tree might be lost.");
                                }
                            } else {
                                StorageIndexingTreeHandler.this.executorService.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                            }
                        }
                    };
                    StorageIndexingTreeHandler.this.executorService.submit(writeOldIndexingTree);
                    break;
                }
            }
            catch (Exception e) {
                StorageIndexingTreeHandler.this.log.error("Indexing tree saving task encountered an error.", (Throwable)e);
            }
        }
    }
}

