/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum StorageFileType {
    INDEX_FILE(".index"),
    DATA_FILE(".itdata"),
    AGENT_FILE(".agent"),
    STORAGE_FILE(".storage"),
    LOCAL_STORAGE_FILE(".local"),
    ZIP_STORAGE_FILE(".itds"),
    CACHED_DATA_FILE(".cached");

    private static final Map<String, StorageFileType> LOOKUP;
    private String extension;

    private StorageFileType(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public static StorageFileType fromExtension(String extension) {
        return LOOKUP.get(extension);
    }

    public String toString() {
        return super.toString() + " (" + this.extension + ")";
    }

    static {
        LOOKUP = new HashMap<String, StorageFileType>();
        for (StorageFileType fileType : EnumSet.allOf(StorageFileType.class)) {
            LOOKUP.put(fileType.getExtension(), fileType);
        }
    }
}

