/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage;

import info.novatec.inspectit.storage.AbstractStorageData;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.DateStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.CreationDateLabelType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StorageData
extends AbstractStorageData {
    private static final long serialVersionUID = -7907538407211424496L;
    private List<AbstractStorageLabel<?>> labelList = new ArrayList();
    private StorageState state;

    public StorageData() {
        this.state = StorageState.CREATED_NOT_OPENED;
        DateStorageLabel dateLabel = new DateStorageLabel();
        dateLabel.setStorageLabelType(new CreationDateLabelType());
        dateLabel.setDateValue(new Date());
        this.labelList.add(dateLabel);
    }

    public StorageData(IStorageData storageData) {
        this.setId(storageData.getId());
        this.setName(storageData.getName());
        this.setDescription(storageData.getDescription());
        this.setDiskSize(storageData.getDiskSize());
        this.setCmrVersion(storageData.getCmrVersion());
        this.labelList = new ArrayList(storageData.getLabelList());
        this.state = storageData instanceof StorageData ? ((StorageData)storageData).getState() : StorageState.CLOSED;
    }

    @Override
    public List<AbstractStorageLabel<?>> getLabelList() {
        return this.labelList;
    }

    public StorageState getState() {
        return this.state;
    }

    public boolean isStorageOpened() {
        return this.state.equals((Object)StorageState.OPENED) || this.state.equals((Object)StorageState.RECORDING);
    }

    public void markOpened() {
        this.state = StorageState.OPENED;
    }

    public boolean isStorageClosed() {
        return this.state.equals((Object)StorageState.CLOSED);
    }

    public void markClosed() {
        this.state = StorageState.CLOSED;
    }

    public boolean isStorageRecording() {
        return this.state.equals((Object)StorageState.RECORDING);
    }

    public void markRecording() {
        this.state = StorageState.RECORDING;
    }

    public void addLabel(AbstractStorageLabel<?> label, boolean doOverwrite) {
        if (label.getStorageLabelType().isOnePerStorage()) {
            boolean exists = false;
            for (AbstractStorageLabel<?> existingLabel : this.labelList) {
                if (!label.getStorageLabelType().equals(existingLabel.getStorageLabelType())) continue;
                exists = true;
                if (!doOverwrite) break;
                this.labelList.remove(existingLabel);
                this.labelList.add(label);
                break;
            }
            if (!exists) {
                this.labelList.add(label);
            }
        } else if (!this.labelList.contains(label)) {
            this.labelList.add(label);
        }
    }

    public boolean removeLabel(AbstractStorageLabel<?> label) {
        return this.labelList.remove(label);
    }

    public boolean isLabelPresent(AbstractStorageLabelType<?> labelType) {
        for (AbstractStorageLabel<?> label : this.labelList) {
            if (!label.getStorageLabelType().equals(labelType)) continue;
            return true;
        }
        return false;
    }

    public <T> List<AbstractStorageLabel<T>> getLabels(AbstractStorageLabelType<T> labelType) {
        ArrayList<AbstractStorageLabel<T>> labels = new ArrayList<AbstractStorageLabel<T>>();
        for (AbstractStorageLabel<?> label : this.labelList) {
            if (!label.getStorageLabelType().equals(labelType)) continue;
            labels.add(label);
        }
        return labels;
    }

    public static enum StorageState {
        CREATED_NOT_OPENED,
        OPENED,
        RECORDING,
        CLOSED;

    }
}

