/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.indexer.impl.InvocationChildrenIndexer;
import info.novatec.inspectit.indexing.indexer.impl.MethodIdentIndexer;
import info.novatec.inspectit.indexing.indexer.impl.ObjectTypeIndexer;
import info.novatec.inspectit.indexing.indexer.impl.PlatformIdentIndexer;
import info.novatec.inspectit.indexing.indexer.impl.SqlStringIndexer;
import info.novatec.inspectit.indexing.indexer.impl.TimestampIndexer;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageBranch;
import info.novatec.inspectit.indexing.storage.impl.StorageBranchIndexer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.stereotype.Component;

@Component(value="storageRootBranchFactory")
public class StorageRootBranchFactory
implements FactoryBean<IStorageTreeComponent<DefaultData>> {
    public IStorageTreeComponent<DefaultData> getObject() throws Exception {
        StorageBranchIndexer timestampIndexer = new StorageBranchIndexer(new TimestampIndexer(), true);
        StorageBranchIndexer sqlStringIndexer = new StorageBranchIndexer(new SqlStringIndexer(10), timestampIndexer, false);
        StorageBranchIndexer methodIdentIndexer = new StorageBranchIndexer(new MethodIdentIndexer(), sqlStringIndexer, false);
        StorageBranchIndexer objectTypeIndexer = new StorageBranchIndexer(new ObjectTypeIndexer(), methodIdentIndexer, false);
        StorageBranchIndexer invocationChildrenIndexer = new StorageBranchIndexer(new InvocationChildrenIndexer(), objectTypeIndexer, false);
        StorageBranchIndexer platformIndexer = new StorageBranchIndexer(new PlatformIdentIndexer(), invocationChildrenIndexer, false);
        return new StorageBranch<DefaultData>(platformIndexer);
    }

    public Class<?> getObjectType() {
        return IStorageTreeComponent.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

