/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.indexer.IBranchIndexer;
import info.novatec.inspectit.indexing.storage.IStorageBranchIndexer;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.ArrayBasedStorageLeaf;
import info.novatec.inspectit.indexing.storage.impl.LeafWithNoDescriptors;
import info.novatec.inspectit.indexing.storage.impl.StorageBranch;
import info.novatec.inspectit.storage.util.StorageUtil;
import org.apache.commons.lang.builder.ToStringBuilder;

public class StorageBranchIndexer<E extends DefaultData>
implements IStorageBranchIndexer<E> {
    private int id;
    private IBranchIndexer<E> delegateIndexer;
    private StorageBranchIndexer<E> childIndexer;
    private boolean passId;

    public StorageBranchIndexer() {
    }

    public StorageBranchIndexer(IBranchIndexer<E> delegateIndexer, boolean passId) {
        this(delegateIndexer, null, StorageUtil.getRandomInt(), passId);
    }

    public StorageBranchIndexer(IBranchIndexer<E> delegateIndexer, StorageBranchIndexer<E> childIndexer, boolean passId) {
        this(delegateIndexer, childIndexer, StorageUtil.getRandomInt(), passId);
    }

    public StorageBranchIndexer(IBranchIndexer<E> delegateIndexer, StorageBranchIndexer<E> childIndexer, int id, boolean sharedId) {
        this.delegateIndexer = delegateIndexer;
        this.childIndexer = childIndexer;
        this.id = id;
        this.passId = sharedId;
    }

    @Override
    public Object getKey(E element) {
        return this.delegateIndexer.getKey(element);
    }

    @Override
    public Object[] getKeys(IIndexQuery query) {
        return this.delegateIndexer.getKeys(query);
    }

    @Override
    public boolean sharedInstance() {
        return this.delegateIndexer.sharedInstance();
    }

    @Override
    public IStorageBranchIndexer<E> getNewInstance() {
        IBranchIndexer<E> branchIndexer = null;
        branchIndexer = this.sharedInstance() ? this.delegateIndexer : this.delegateIndexer.getNewInstance();
        StorageBranchIndexer<E> storageBranchIndexer = new StorageBranchIndexer<E>(branchIndexer, this.childIndexer, this.passId);
        return storageBranchIndexer;
    }

    @Override
    public IStorageTreeComponent<E> getNextTreeComponent(E object) {
        if (null != this.childIndexer) {
            if (!this.childIndexer.isPassId() && !this.passId) {
                return new StorageBranch<E>(this.childIndexer);
            }
            IBranchIndexer indexer = this.childIndexer.getNewInstance();
            if (this.passId) {
                indexer.setId(this.id);
            }
            return new StorageBranch(indexer);
        }
        if (object instanceof InvocationSequenceData) {
            if (this.passId) {
                return new ArrayBasedStorageLeaf(this.id);
            }
            return new ArrayBasedStorageLeaf();
        }
        if (this.passId) {
            return new LeafWithNoDescriptors(this.id);
        }
        return new LeafWithNoDescriptors();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public boolean isPassId() {
        return this.passId;
    }

    public void setPassId(boolean sharedId) {
        this.passId = sharedId;
    }

    IBranchIndexer<E> getDelegateIndexer() {
        return this.delegateIndexer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childIndexer == null ? 0 : this.childIndexer.hashCode());
        result = 31 * result + (this.delegateIndexer == null ? 0 : this.delegateIndexer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageBranchIndexer other = (StorageBranchIndexer)obj;
        if (this.childIndexer == null ? other.childIndexer != null : !this.childIndexer.equals(other.childIndexer)) {
            return false;
        }
        return !(this.delegateIndexer == null ? other.delegateIndexer != null : !this.delegateIndexer.equals(other.delegateIndexer));
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("id", this.id);
        toStringBuilder.append("delegateIndexer", this.delegateIndexer);
        toStringBuilder.append("childIndexer", this.childIndexer);
        toStringBuilder.append("passId", this.passId);
        return toStringBuilder.toString();
    }
}

