/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.restriction.impl;

import info.novatec.inspectit.indexing.restriction.AbstractIndexQueryRestriction;
import info.novatec.inspectit.indexing.restriction.IIndexQueryRestriction;
import info.novatec.inspectit.indexing.restriction.impl.ComparableIndexQueryRestriction;
import info.novatec.inspectit.indexing.restriction.impl.ObjectIndexQueryRestriction;
import java.util.Collection;

public final class IndexQueryRestrictionFactory {
    private IndexQueryRestrictionFactory() {
    }

    public static IIndexQueryRestriction equal(String fieldName, Object restrictionValue) {
        return new EqualsIndexingRestriction(fieldName, restrictionValue);
    }

    public static IIndexQueryRestriction notEqual(String fieldName, Object restrictionValue) {
        return new NotEqualsIndexingRestriction(fieldName, restrictionValue);
    }

    public static IIndexQueryRestriction greaterThan(String fieldName, Comparable<? extends Object> restrictionValue) {
        return new GreaterThanIndexingRestriction(fieldName, restrictionValue);
    }

    public static IIndexQueryRestriction greaterEqual(String fieldName, Comparable<? extends Object> restrictionValue) {
        return new GreaterEqualsIndexingRestriction(fieldName, restrictionValue);
    }

    public static IIndexQueryRestriction lessThan(String fieldName, Comparable<? extends Object> restrictionValue) {
        return new LessThanIndexingRestriction(fieldName, restrictionValue);
    }

    public static IIndexQueryRestriction lessEqual(String fieldName, Comparable<? extends Object> restrictionValue) {
        return new LessEqualsIndexingRestriction(fieldName, restrictionValue);
    }

    public static IIndexQueryRestriction isNull(String fieldName) {
        return new IsNullIndexingRestriction(fieldName);
    }

    public static IIndexQueryRestriction isNotNull(String fieldName) {
        return new IsNotNullIndexingRestriction(fieldName);
    }

    public static IIndexQueryRestriction isInCollection(String fieldName, Collection<?> collection) {
        return new IsInCollection(fieldName, collection);
    }

    public static IIndexQueryRestriction areAllInCollection(String fieldName, Collection<?> collection) {
        return new AreAllInCollection(fieldName, collection);
    }

    private static class AreAllInCollection
    extends AbstractIndexQueryRestriction {
        private Collection<?> collection;

        public AreAllInCollection(String fieldName, Collection<?> collection) {
            super(fieldName);
            this.collection = collection;
        }

        public boolean isFulfilled(Object fieldValue) {
            if (fieldValue instanceof Collection) {
                return this.collection.containsAll((Collection)fieldValue);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AreAllInCollection other = (AreAllInCollection)obj;
            return !(this.collection == null ? other.collection != null : !this.collection.equals(other.collection));
        }
    }

    private static class IsInCollection
    extends AbstractIndexQueryRestriction {
        private Collection<?> collection;

        public IsInCollection(String fieldName, Collection<?> collection) {
            super(fieldName);
            this.collection = collection;
        }

        public boolean isFulfilled(Object fieldValue) {
            return this.collection != null && this.collection.contains(fieldValue);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IsInCollection other = (IsInCollection)obj;
            return !(this.collection == null ? other.collection != null : !this.collection.equals(other.collection));
        }
    }

    private static class IsNotNullIndexingRestriction
    extends AbstractIndexQueryRestriction {
        public IsNotNullIndexingRestriction(String fieldName) {
            super(fieldName);
        }

        public boolean isFulfilled(Object object) {
            return object != null;
        }
    }

    private static class IsNullIndexingRestriction
    extends AbstractIndexQueryRestriction {
        public IsNullIndexingRestriction(String fieldName) {
            super(fieldName);
        }

        public boolean isFulfilled(Object object) {
            return object == null;
        }
    }

    private static class LessEqualsIndexingRestriction
    extends ComparableIndexQueryRestriction {
        public LessEqualsIndexingRestriction(String fieldName, Comparable<? extends Object> restrictionValue) {
            super(fieldName, restrictionValue);
        }

        public boolean isFulfilled(Object object) {
            if (null == this.getRestrictionValue()) {
                return false;
            }
            return 0 <= this.getRestrictionValue().compareTo(object);
        }
    }

    private static class LessThanIndexingRestriction
    extends ComparableIndexQueryRestriction {
        public LessThanIndexingRestriction(String fieldName, Comparable<? extends Object> restrictionValue) {
            super(fieldName, restrictionValue);
        }

        public boolean isFulfilled(Object object) {
            if (null == this.getRestrictionValue()) {
                return false;
            }
            return 0 < this.getRestrictionValue().compareTo(object);
        }
    }

    private static class GreaterEqualsIndexingRestriction
    extends ComparableIndexQueryRestriction {
        public GreaterEqualsIndexingRestriction(String fieldName, Comparable<? extends Object> restrictionValue) {
            super(fieldName, restrictionValue);
        }

        public boolean isFulfilled(Object object) {
            if (null == this.getRestrictionValue()) {
                return false;
            }
            return 0 >= this.getRestrictionValue().compareTo(object);
        }
    }

    private static class GreaterThanIndexingRestriction
    extends ComparableIndexQueryRestriction {
        public GreaterThanIndexingRestriction(String fieldName, Comparable<? extends Object> restrictionValue) {
            super(fieldName, restrictionValue);
        }

        public boolean isFulfilled(Object object) {
            if (null == this.getRestrictionValue()) {
                return false;
            }
            return 0 > this.getRestrictionValue().compareTo(object);
        }
    }

    private static class NotEqualsIndexingRestriction
    extends ObjectIndexQueryRestriction {
        public NotEqualsIndexingRestriction(String fieldName, Object restrictionValue) {
            super(fieldName, restrictionValue);
        }

        public boolean isFulfilled(Object object) {
            if (null == this.getRestrictionValue()) {
                return null != object;
            }
            return !this.getRestrictionValue().equals(object);
        }
    }

    private static class EqualsIndexingRestriction
    extends ObjectIndexQueryRestriction {
        public EqualsIndexingRestriction(String fieldName, Object restrictionValue) {
            super(fieldName, restrictionValue);
        }

        public boolean isFulfilled(Object object) {
            if (null == this.getRestrictionValue()) {
                return null == object;
            }
            return this.getRestrictionValue().equals(object);
        }
    }
}

