/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.indexer.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.indexer.AbstractSharedInstanceBranchIndexer;
import info.novatec.inspectit.indexing.indexer.IBranchIndexer;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;

public class SqlStringIndexer<E extends DefaultData>
extends AbstractSharedInstanceBranchIndexer<E>
implements IBranchIndexer<E> {
    private final int maxKeys;

    public SqlStringIndexer() {
        this(-1);
    }

    public SqlStringIndexer(int maxKeys) {
        this.maxKeys = maxKeys;
    }

    @Override
    public Object getKey(E element) {
        SqlStatementData sqlStatementData;
        if (element instanceof SqlStatementData && null != (sqlStatementData = (SqlStatementData)element).getSql()) {
            return this.getInternalHash(sqlStatementData.getSql().hashCode());
        }
        return 0;
    }

    @Override
    public Object[] getKeys(IIndexQuery query) {
        if (query instanceof StorageIndexQuery && null != ((StorageIndexQuery)query).getSql()) {
            Object[] keys = new Object[]{this.getInternalHash(((StorageIndexQuery)query).getSql().hashCode())};
            return keys;
        }
        return new Object[0];
    }

    private Integer getInternalHash(int hashCode) {
        if (this.maxKeys > 0) {
            return Math.abs(hashCode % this.maxKeys);
        }
        return hashCode;
    }
}

