/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.buffer.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.buffer.IBufferBranchIndexer;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import info.novatec.inspectit.indexing.buffer.impl.Branch;
import info.novatec.inspectit.indexing.buffer.impl.Leaf;
import info.novatec.inspectit.indexing.indexer.IBranchIndexer;
import org.apache.commons.lang.builder.ToStringBuilder;

public class BufferBranchIndexer<E extends DefaultData>
implements IBufferBranchIndexer<E> {
    private IBranchIndexer<E> delegateIndexer;
    private BufferBranchIndexer<E> childBufferIndexer;

    public BufferBranchIndexer(IBranchIndexer<E> delegateIndexer) {
        this(delegateIndexer, null);
    }

    public BufferBranchIndexer(IBranchIndexer<E> delegateIndexer, BufferBranchIndexer<E> childBufferIndexer) {
        this.delegateIndexer = delegateIndexer;
        this.childBufferIndexer = childBufferIndexer;
    }

    @Override
    public Object getKey(E element) {
        return this.delegateIndexer.getKey(element);
    }

    @Override
    public Object[] getKeys(IIndexQuery query) {
        return this.delegateIndexer.getKeys(query);
    }

    @Override
    public IBufferBranchIndexer<E> getChildIndexer() {
        return this.childBufferIndexer;
    }

    @Override
    public boolean sharedInstance() {
        return this.delegateIndexer.sharedInstance();
    }

    @Override
    public IBufferBranchIndexer<E> getNewInstance() {
        if (!this.sharedInstance()) {
            BufferBranchIndexer<E> bufferBranchIndexer = new BufferBranchIndexer<E>(this.delegateIndexer.getNewInstance(), this.childBufferIndexer);
            return bufferBranchIndexer;
        }
        throw new UnsupportedOperationException("Method getNewInstance() called on the Indexer that has a shared instance.");
    }

    @Override
    public IBufferTreeComponent<E> getNextTreeComponent() {
        if (null != this.childBufferIndexer) {
            if (this.childBufferIndexer.sharedInstance()) {
                return new Branch<E>(this.childBufferIndexer);
            }
            return new Branch(this.childBufferIndexer.getNewInstance());
        }
        return new Leaf();
    }

    IBranchIndexer<E> getDelegateIndexer() {
        return this.delegateIndexer;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("delegateIndexer", this.delegateIndexer);
        return toStringBuilder.toString();
    }
}

