/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.ITreeComponent;
import info.novatec.inspectit.indexing.QueryTask;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.indexing.indexer.IBranchIndexer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractBranch<R, E>
implements ITreeComponent<R, E> {
    private static final int CONCURRENCY_LEVEL = 4;
    private IBranchIndexer<E> branchIndexer;
    private ConcurrentHashMap<Object, ITreeComponent<R, E>> map;

    public AbstractBranch(IBranchIndexer<E> branchIndexer) {
        this.branchIndexer = branchIndexer;
        this.map = new ConcurrentHashMap(1, 0.75f, 4);
    }

    protected IBranchIndexer<E> getBranchIndexer() {
        return this.branchIndexer;
    }

    protected abstract ITreeComponent<R, E> getNextTreeComponent(E var1);

    @Override
    public R put(E element) throws IndexingException {
        ITreeComponent<R, E> existing;
        Object key = this.branchIndexer.getKey(element);
        if (null == key) {
            throw new IndexingException("Branch indexer " + this.branchIndexer + " can not create the key for the object " + element + ".");
        }
        ITreeComponent<R, E> treeComponent = this.map.get(key);
        if (null != treeComponent) {
            return treeComponent.put(element);
        }
        treeComponent = this.map.get(key);
        if (null == treeComponent && null != (existing = this.map.putIfAbsent(key, treeComponent = this.getNextTreeComponent(element)))) {
            treeComponent = existing;
        }
        return treeComponent.put(element);
    }

    @Override
    public R get(E template) {
        Object key = this.branchIndexer.getKey(template);
        ITreeComponent<R, E> treeComponent = null;
        if (null != key) {
            treeComponent = this.map.get(key);
        }
        if (null != treeComponent) {
            return treeComponent.get(template);
        }
        if (null == key) {
            Iterator<ITreeComponent<R, E>> iterator = this.map.values().iterator();
            R result = null;
            while (iterator.hasNext()) {
                result = iterator.next().get(template);
                if (null == result) continue;
                return result;
            }
            return null;
        }
        return null;
    }

    @Override
    public R getAndRemove(E template) {
        Object key = this.getBranchIndexer().getKey(template);
        ITreeComponent<R, E> treeComponent = null;
        if (null != key) {
            treeComponent = this.map.get(key);
        }
        if (null != treeComponent) {
            return treeComponent.getAndRemove(template);
        }
        if (null == key) {
            Iterator<ITreeComponent<R, E>> iterator = this.map.values().iterator();
            R result = null;
            while (iterator.hasNext()) {
                result = iterator.next().getAndRemove(template);
                if (null == result) continue;
                return result;
            }
            return null;
        }
        return null;
    }

    @Override
    public List<R> query(IIndexQuery query) {
        Object[] keys = this.getBranchIndexer().getKeys(query);
        if (ArrayUtils.isEmpty((Object[])keys)) {
            return this.queryAllTreeComponents(query);
        }
        if (1 == keys.length) {
            return this.querySingleKey(query, keys[0]);
        }
        ArrayList<R> results = new ArrayList<R>();
        for (Object key : keys) {
            List<R> componentResult = this.querySingleKey(query, key);
            if (null == componentResult || componentResult.isEmpty()) continue;
            results.addAll(componentResult);
        }
        return results;
    }

    @Override
    public List<R> query(IIndexQuery query, ForkJoinPool forkJoinPool) {
        return forkJoinPool.invoke(this.getTaskForForkJoinQuery(query));
    }

    protected List<R> querySingleKey(IIndexQuery query, Object key) {
        ITreeComponent<R, E> treeComponent = null;
        if (null != key) {
            treeComponent = this.map.get(key);
        }
        if (null != treeComponent) {
            return treeComponent.query(query);
        }
        return Collections.emptyList();
    }

    protected List<R> queryAllTreeComponents(IIndexQuery query) {
        ArrayList<R> results = new ArrayList<R>();
        Iterator<ITreeComponent<R, E>> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            List<R> componentResult = iterator.next().query(query);
            if (null == componentResult || componentResult.isEmpty()) continue;
            results.addAll(componentResult);
        }
        return results;
    }

    @Override
    public long getComponentSize(IObjectSizes objectSizes) {
        int mapSize = this.map.size();
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(2, 0, 0, 0, 0, 0);
        size += objectSizes.getSizeOfConcurrentHashMap(mapSize, 4);
        size += (long)mapSize * objectSizes.getSizeOfLongObject();
        for (ITreeComponent<R, E> treeComponent : this.map.values()) {
            size += treeComponent.getComponentSize(objectSizes);
        }
        return size;
    }

    public void clearAll() {
        this.map.clear();
    }

    public Map<Object, ITreeComponent<R, E>> getComponentMap() {
        return this.map;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branchIndexer == null ? 0 : this.branchIndexer.hashCode());
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBranch other = (AbstractBranch)obj;
        if (this.branchIndexer == null ? other.branchIndexer != null : !this.branchIndexer.equals(other.branchIndexer)) {
            return false;
        }
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("branchIndexer", this.branchIndexer);
        toStringBuilder.append("branchMap", this.map);
        return toStringBuilder.toString();
    }

    public Collection<ITreeComponent<R, E>> getBranchesToQuery(IIndexQuery query) {
        Object[] keys = this.getBranchIndexer().getKeys(query);
        if (ArrayUtils.isEmpty((Object[])keys)) {
            return this.map.values();
        }
        ArrayList<ITreeComponent<R, ITreeComponent<R, E>>> branchesToQuery = new ArrayList<ITreeComponent<R, ITreeComponent<R, E>>>();
        for (Object key : keys) {
            ITreeComponent<R, E> branch = this.map.get(key);
            if (branch == null) continue;
            branchesToQuery.add(branch);
        }
        return branchesToQuery;
    }

    @Override
    public RecursiveTask<List<R>> getTaskForForkJoinQuery(IIndexQuery query) {
        return new QueryTask<R, E>(this.getBranchesToQuery(query), query);
    }
}

