/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.update.configuration;

import info.novatec.inspectit.cmr.property.update.AbstractPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.impl.RestoreDefaultPropertyUpdate;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.collections.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="cmr-configuration-update")
@XmlSeeAlso(value={AbstractPropertyUpdate.class, RestoreDefaultPropertyUpdate.class})
public class ConfigurationUpdate {
    @XmlElementWrapper(name="updates")
    @XmlElementRefs(value={@XmlElementRef(type=AbstractPropertyUpdate.class), @XmlElementRef(type=RestoreDefaultPropertyUpdate.class)})
    private Set<IPropertyUpdate<?>> propertyUpdates = new HashSet();

    public void merge(ConfigurationUpdate other, boolean overwrite) {
        if (CollectionUtils.isNotEmpty(other.getPropertyUpdates())) {
            for (IPropertyUpdate<?> propertyUpdate : other.getPropertyUpdates()) {
                IPropertyUpdate<?> thisPropertyUpdate = this.forLogicalName(propertyUpdate.getPropertyLogicalName());
                if (null != thisPropertyUpdate) {
                    if (!overwrite) continue;
                    this.removePropertyUpdate(thisPropertyUpdate);
                    this.addPropertyUpdate(propertyUpdate);
                    continue;
                }
                this.addPropertyUpdate(propertyUpdate);
            }
        }
    }

    public IPropertyUpdate<?> forLogicalName(String propertyLogicalName) {
        if (CollectionUtils.isNotEmpty(this.propertyUpdates)) {
            for (IPropertyUpdate<?> propertyUpdate : this.propertyUpdates) {
                if (!ObjectUtils.equals((Object)propertyLogicalName, (Object)propertyUpdate.getPropertyLogicalName())) continue;
                return propertyUpdate;
            }
        }
        return null;
    }

    public void addPropertyUpdate(IPropertyUpdate<?> propertyUpdate) {
        this.propertyUpdates.add(propertyUpdate);
    }

    public void removePropertyUpdate(IPropertyUpdate<?> propertyUpdate) {
        this.propertyUpdates.remove(propertyUpdate);
    }

    public Set<IPropertyUpdate<?>> getPropertyUpdates() {
        return this.propertyUpdates;
    }

    public void setPropertyUpdates(Set<IPropertyUpdate<?>> propertyUpdates) {
        this.propertyUpdates = propertyUpdates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyUpdates == null ? 0 : this.propertyUpdates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationUpdate other = (ConfigurationUpdate)obj;
        return !(this.propertyUpdates == null ? other.propertyUpdates != null : !this.propertyUpdates.equals(other.propertyUpdates));
    }
}

