/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration.validator;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import java.util.Collections;

public abstract class AbstractSinglePropertyValidator<T> {
    protected abstract boolean prove(T var1);

    protected abstract String getErrorMessage(SingleProperty<? extends T> var1);

    public void validate(SingleProperty<? extends T> property, PropertyValidation propertyValidation) {
        if (!this.prove(property.getValue())) {
            this.addValidationError(property, propertyValidation, this.getErrorMessage(property));
        }
    }

    public void validateForValue(SingleProperty<? extends T> property, PropertyValidation propertyValidation, T value) {
        if (!this.prove(value)) {
            this.addValidationError(property, propertyValidation, this.getErrorMessage(property));
        }
    }

    private void addValidationError(SingleProperty<? extends T> property, PropertyValidation propertyValidation, String message) {
        ValidationError validationError = new ValidationError(Collections.singletonList(property), message);
        propertyValidation.addValidationError(validationError);
    }
}

