/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration.validator;

import info.novatec.inspectit.cmr.property.configuration.GroupedProperty;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import info.novatec.inspectit.cmr.property.configuration.validator.IGroupedProperyValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.ISinglePropertyValidator;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractComparingValidator<T>
implements IGroupedProperyValidator,
ISinglePropertyValidator<T> {
    @XmlAttribute(name="property", required=false)
    private String property;
    @XmlAttribute(name="than", required=true)
    private String than;

    protected abstract void compare(SingleProperty<? extends T> var1, SingleProperty<? extends T> var2, T var3, T var4, PropertyValidation var5);

    protected abstract void compare(SingleProperty<? extends T> var1, T var2, T var3, PropertyValidation var4);

    @Override
    public void validate(SingleProperty<? extends T> property, PropertyValidation propertyValidation) {
        T against = this.getAgainstValue(property, propertyValidation);
        if (null != against) {
            this.compare(property, property.getValue(), against, propertyValidation);
        }
    }

    @Override
    public void validateForValue(SingleProperty<? extends T> property, PropertyValidation propertyValidation, T value) {
        T against = this.getAgainstValue(property, propertyValidation);
        if (null != against) {
            this.compare(property, value, against, propertyValidation);
        }
    }

    private T getAgainstValue(SingleProperty<? extends T> property, PropertyValidation propertyValidation) {
        T against = property.parseLiteral(this.than);
        if (null == against) {
            ValidationError validationError = new ValidationError(Collections.singletonList(property), "Validation of  property " + property.getName() + " failed because literal (" + this.than + ") to compare against can not be parsed.");
            propertyValidation.addValidationError(validationError);
        }
        return against;
    }

    @Override
    public void validate(GroupedProperty groupProperty, PropertyValidation propertyValidation) {
        SingleProperty<?> compare = this.getProperty(groupProperty, propertyValidation);
        SingleProperty<?> against = this.getAgainstProperty(groupProperty, propertyValidation);
        if (null == compare || null == against) {
            return;
        }
        try {
            this.compare(compare, against, compare.getValue(), against.getValue(), propertyValidation);
        }
        catch (Exception e) {
            ValidationError validationError = new ValidationError(new ArrayList(groupProperty.getSingleProperties()), "Validation of grouped property " + groupProperty.getName() + " failed because exception occurred during validation. Exception message: " + e.getMessage());
            propertyValidation.addValidationError(validationError);
        }
    }

    @Override
    public void validateForPropertyUpdates(GroupedProperty groupProperty, Collection<IPropertyUpdate<?>> propertyUpdates, PropertyValidation propertyValidation) {
        SingleProperty<?> compareProperty = this.getProperty(groupProperty, propertyValidation);
        SingleProperty<?> againstProperty = this.getAgainstProperty(groupProperty, propertyValidation);
        if (null == compareProperty || null == againstProperty) {
            return;
        }
        Object value = compareProperty.getValue();
        Object against = againstProperty.getValue();
        for (IPropertyUpdate<?> propertyUpdate : propertyUpdates) {
            if (Objects.equals(compareProperty.getLogicalName(), propertyUpdate.getPropertyLogicalName())) {
                value = propertyUpdate.getUpdateValue();
            }
            if (!Objects.equals(againstProperty.getLogicalName(), propertyUpdate.getPropertyLogicalName())) continue;
            against = propertyUpdate.getUpdateValue();
        }
        if (Objects.equals(value, compareProperty.getValue()) && Objects.equals(against, againstProperty.getValue())) {
            return;
        }
        try {
            this.compare(compareProperty, againstProperty, value, against, propertyValidation);
        }
        catch (Exception e) {
            ValidationError validationError = new ValidationError(new ArrayList(groupProperty.getSingleProperties()), "Validation of grouped property " + groupProperty.getName() + " failed because exception occurred during validation. Exception message: " + e.getMessage());
            propertyValidation.addValidationError(validationError);
        }
    }

    private SingleProperty<?> getProperty(GroupedProperty groupProperty, PropertyValidation propertyValidation) {
        if (StringUtils.isEmpty((String)this.property)) {
            ValidationError validationError = new ValidationError(new ArrayList(groupProperty.getSingleProperties()), "Validation of grouped property " + groupProperty.getName() + " failed because property logical name is not set.");
            propertyValidation.addValidationError(validationError);
            return null;
        }
        SingleProperty<?> p = groupProperty.forLogicalname(this.property);
        if (null == p) {
            ValidationError validationError = new ValidationError(new ArrayList(groupProperty.getSingleProperties()), "Validation of grouped property " + groupProperty.getName() + " failed because property with logical name '" + this.property + "' does not exist.");
            propertyValidation.addValidationError(validationError);
        }
        return p;
    }

    private SingleProperty<?> getAgainstProperty(GroupedProperty groupProperty, PropertyValidation propertyValidation) {
        if (StringUtils.isEmpty((String)this.than)) {
            ValidationError validationError = new ValidationError(new ArrayList(groupProperty.getSingleProperties()), "Validation of grouped property " + groupProperty.getName() + " failed because logical name of the property to compare against is not set.");
            propertyValidation.addValidationError(validationError);
            return null;
        }
        SingleProperty<?> p = groupProperty.forLogicalname(this.than);
        if (null == p) {
            ValidationError validationError = new ValidationError(new ArrayList(groupProperty.getSingleProperties()), "Validation of grouped property " + groupProperty.getName() + " failed because property with logical name '" + this.than + "' does not exist.");
            propertyValidation.addValidationError(validationError);
        }
        return p;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getThan() {
        return this.than;
    }

    public void setThan(String than) {
        this.than = than;
    }
}

