/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration;

import info.novatec.inspectit.cmr.property.configuration.AbstractProperty;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidationException;
import info.novatec.inspectit.cmr.property.configuration.validator.IGroupedProperyValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.GreaterOrEqualValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.GreaterValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.LessOrEqualValidator;
import info.novatec.inspectit.cmr.property.configuration.validator.impl.LessValidator;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="group-property")
public class GroupedProperty
extends AbstractProperty {
    @XmlElementWrapper(name="properties", required=true)
    @XmlElementRef
    private Set<SingleProperty<?>> singleProperties = new LinkedHashSet();
    @XmlElementWrapper(name="group-validators")
    @XmlElementRefs(value={@XmlElementRef(type=LessValidator.class), @XmlElementRef(type=LessOrEqualValidator.class), @XmlElementRef(type=GreaterValidator.class), @XmlElementRef(type=GreaterOrEqualValidator.class)})
    private List<IGroupedProperyValidator> validators;

    public GroupedProperty() {
    }

    public GroupedProperty(String name, String description) throws IllegalArgumentException {
        super(name, description);
    }

    @Override
    public boolean isAdvanced() {
        if (CollectionUtils.isNotEmpty(this.singleProperties)) {
            for (SingleProperty<?> singleProperty : this.singleProperties) {
                if (!singleProperty.isAdvanced()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isServerRestartRequired() {
        if (CollectionUtils.isNotEmpty(this.singleProperties)) {
            for (SingleProperty<?> singleProperty : this.singleProperties) {
                if (!singleProperty.isServerRestartRequired()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void validate(PropertyValidation propertyValidation) {
        if (CollectionUtils.isNotEmpty(this.singleProperties)) {
            for (SingleProperty<?> property : this.singleProperties) {
                property.validate(propertyValidation);
            }
        }
        if (CollectionUtils.isNotEmpty(this.validators)) {
            for (IGroupedProperyValidator validator : this.validators) {
                validator.validate(this, propertyValidation);
            }
        }
    }

    public void validateForPropertiesUpdate(Collection<IPropertyUpdate<?>> propertyUpdates) throws PropertyValidationException {
        PropertyValidation propertyValidation = PropertyValidation.createFor(this);
        for (IGroupedProperyValidator groupedProperyValidator : this.validators) {
            groupedProperyValidator.validateForPropertyUpdates(this, propertyUpdates, propertyValidation);
        }
        if (propertyValidation.hasErrors()) {
            throw new PropertyValidationException(propertyValidation);
        }
    }

    @Override
    public void register(Properties properties) {
        if (CollectionUtils.isNotEmpty(this.singleProperties)) {
            for (SingleProperty<?> property : this.singleProperties) {
                property.register(properties);
            }
        }
    }

    @Override
    public SingleProperty<?> forLogicalname(String propertyLogicalName) {
        for (AbstractProperty abstractProperty : this.singleProperties) {
            SingleProperty<?> returnProperty = abstractProperty.forLogicalname(propertyLogicalName);
            if (null == returnProperty) continue;
            return returnProperty;
        }
        return null;
    }

    public Set<SingleProperty<?>> getSingleProperties() {
        return this.singleProperties;
    }

    public void addSingleProperty(SingleProperty<?> property) {
        this.singleProperties.add(property);
    }

    public void addValidator(IGroupedProperyValidator validator) {
        if (null == this.validators) {
            this.validators = new ArrayList<IGroupedProperyValidator>();
        }
        this.validators.add(validator);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.singleProperties == null ? 0 : this.singleProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupedProperty other = (GroupedProperty)obj;
        return !(this.singleProperties == null ? other.singleProperties != null : !this.singleProperties.equals(other.singleProperties));
    }
}

