/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration;

import info.novatec.inspectit.cmr.property.configuration.GroupedProperty;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={SingleProperty.class, GroupedProperty.class})
public abstract class AbstractProperty {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="description")
    private String description;

    public AbstractProperty() {
    }

    public AbstractProperty(String name, String description) throws IllegalArgumentException {
        if (null == name) {
            throw new IllegalArgumentException("Name of the property must not be null.");
        }
        this.name = name;
        this.description = description;
    }

    public abstract boolean isAdvanced();

    public abstract boolean isServerRestartRequired();

    protected abstract void validate(PropertyValidation var1);

    public abstract void register(Properties var1);

    public abstract SingleProperty<?> forLogicalname(String var1);

    public PropertyValidation validate() {
        PropertyValidation errors = PropertyValidation.createFor(this);
        this.validate(errors);
        return errors;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

