/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tiles.Initializable;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.AbstractTilesApplicationContextFactory;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTilesApplicationContextFactory
extends AbstractTilesApplicationContextFactory
implements Initializable {
    private Map<String, String> params;

    public void init(Map<String, String> params) {
        this.params = params;
    }

    public TilesApplicationContext createApplicationContext(Object context) {
        return new SpringWildcardServletTilesApplicationContext((ServletContext)context, this.params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringWildcardServletTilesApplicationContext
    extends ServletTilesApplicationContext {
        private final Map<String, String> mergedInitParams = new LinkedHashMap<String, String>();
        private final ResourcePatternResolver resolver;

        public SpringWildcardServletTilesApplicationContext(ServletContext servletContext, Map<String, String> params) {
            super(servletContext);
            Enumeration initParamNames = servletContext.getInitParameterNames();
            while (initParamNames.hasMoreElements()) {
                String initParamName = (String)initParamNames.nextElement();
                this.mergedInitParams.put(initParamName, servletContext.getInitParameter(initParamName));
            }
            if (params != null) {
                this.mergedInitParams.putAll(params);
            }
            this.resolver = new ServletContextResourcePatternResolver(servletContext);
        }

        public Map<String, String> getInitParams() {
            return this.mergedInitParams;
        }

        public URL getResource(String path) throws IOException {
            Set<URL> urlSet = this.getResources(path);
            if (!CollectionUtils.isEmpty(urlSet)) {
                return urlSet.iterator().next();
            }
            return null;
        }

        public Set<URL> getResources(String path) throws IOException {
            LinkedHashSet<URL> urlSet = null;
            Object[] resources = this.resolver.getResources(path);
            if (!ObjectUtils.isEmpty((Object[])resources)) {
                urlSet = new LinkedHashSet<URL>(resources.length);
                for (Object resource : resources) {
                    urlSet.add(resource.getURL());
                }
            }
            return urlSet;
        }
    }
}

