/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.version;

import info.novatec.inspectit.version.InvalidVersionException;
import info.novatec.inspectit.version.Version;
import info.novatec.inspectit.version.VersionProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionService {
    public static final String UNKNOWN_VERSION = "unknown";
    @Autowired
    private VersionProvider provider;
    private Version cachedVersion;

    public Version getVersion() throws InvalidVersionException {
        if (null == this.cachedVersion) {
            String readVersion = this.provider.readVersion();
            this.cachedVersion = Version.verifyAndCreate(readVersion);
        }
        return this.cachedVersion;
    }

    public String getVersionAsString() {
        try {
            Version version = this.getVersion();
            return version.toString();
        }
        catch (InvalidVersionException e) {
            return UNKNOWN_VERSION;
        }
    }

    public void setProvider(VersionProvider provider) {
        this.provider = provider;
    }
}

