/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.version;

import info.novatec.inspectit.exception.enumeration.VersioningErrorCodeEnum;
import info.novatec.inspectit.util.ResourceUtils;
import info.novatec.inspectit.version.InvalidVersionException;
import info.novatec.inspectit.version.VersionProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileBasedVersionReader
implements VersionProvider {
    public static final String VERSION_LOG_NAME = "version.log";
    @Autowired
    private ResourceUtils resourceUtils;

    public String readVersion() throws InvalidVersionException {
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = this.resourceUtils.getAsStream(VERSION_LOG_NAME);
            if (null == inputStream) {
                throw new InvalidVersionException(VersioningErrorCodeEnum.VERSION_FILE_IO, null);
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String version = reader.readLine();
                if (StringUtils.isEmpty((String)version)) {
                    throw new InvalidVersionException(VersioningErrorCodeEnum.VERSION_NOT_IN_FILE, null);
                }
                String string = version;
                return string;
            }
            catch (IOException e) {
                throw new InvalidVersionException(VersioningErrorCodeEnum.VERSION_FILE_IO, (Throwable)e);
            }
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setResourceUtils(ResourceUtils resourceUtils) {
        this.resourceUtils = resourceUtils;
    }
}

