/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public final class UnderlyingSystemInfo {
    private static final long MAX_COMPRESSED_OOPS_JAVA7_MEMORY = 0x800000000L;
    public static final String JAVA_VENDOR = UnderlyingSystemInfo.getSystemProperty("java.vendor");
    public static final String JAVA_VERSION_FULL = UnderlyingSystemInfo.getSystemProperty("java.version");
    public static final String JAVA_VERSION_TRIMMED = UnderlyingSystemInfo.getJavaVersionTrimmed();
    public static final JavaVersion JAVA_VERSION = UnderlyingSystemInfo.getJavaVersion();
    public static final JvmProvider JVM_PROVIDER = UnderlyingSystemInfo.getJvmProvider();
    public static final boolean IS_64BIT = UnderlyingSystemInfo.is64Bit();
    public static final boolean IS_COMPRESSED_OOPS = UnderlyingSystemInfo.isCompressedOops();

    private UnderlyingSystemInfo() {
    }

    private static JvmProvider getJvmProvider() {
        if (UnderlyingSystemInfo.getJavaVendorMatches("Sun")) {
            return JvmProvider.SUN;
        }
        if (UnderlyingSystemInfo.getJavaVendorMatches("Oracle Corporation")) {
            return JvmProvider.ORACLE;
        }
        if (UnderlyingSystemInfo.getJavaVendorMatches("IBM")) {
            return JvmProvider.IBM;
        }
        return JvmProvider.OTHER;
    }

    private static JavaVersion getJavaVersion() {
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.1")) {
            return JavaVersion.JAVA_1_1;
        }
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.2")) {
            return JavaVersion.JAVA_1_2;
        }
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.3")) {
            return JavaVersion.JAVA_1_3;
        }
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.4")) {
            return JavaVersion.JAVA_1_4;
        }
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.5")) {
            return JavaVersion.JAVA_1_5;
        }
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.6")) {
            return JavaVersion.JAVA_1_6;
        }
        if (UnderlyingSystemInfo.getJavaVersionMatches("1.7")) {
            return JavaVersion.JAVA_1_7;
        }
        return JavaVersion.OTHER;
    }

    private static boolean getJavaVendorMatches(String vendor) {
        if (null != JAVA_VENDOR) {
            return JAVA_VENDOR.indexOf(vendor) != -1;
        }
        return false;
    }

    private static boolean is64Bit() {
        switch (JVM_PROVIDER) {
            case SUN: {
                return System.getProperty("sun.arch.data.model").indexOf("64") != -1;
            }
            case ORACLE: {
                return System.getProperty("sun.arch.data.model").indexOf("64") != -1;
            }
            case IBM: {
                return System.getProperty("com.ibm.vm.bitmode").indexOf("64") != -1;
            }
        }
        return false;
    }

    private static boolean isCompressedOops() {
        if (IS_64BIT) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            if (null != runtimeMXBean) {
                List<String> arguments = runtimeMXBean.getInputArguments();
                for (String argument : arguments) {
                    if (argument.indexOf("+UseCompressedOops") != -1 || argument.indexOf("compressedrefs") != -1) {
                        return true;
                    }
                    if (argument.indexOf("-UseCompressedOops") == -1) continue;
                    return false;
                }
            }
            switch (UnderlyingSystemInfo.getJvmProvider()) {
                case SUN: 
                case ORACLE: {
                    if (UnderlyingSystemInfo.getJavaVersion() == JavaVersion.JAVA_1_7) {
                        long max = Runtime.getRuntime().maxMemory();
                        return max == Long.MAX_VALUE || max < 0x800000000L;
                    }
                    if (UnderlyingSystemInfo.getJavaVersion() != JavaVersion.JAVA_1_6) break;
                    try {
                        int subversionIndexStart = JAVA_VERSION_TRIMMED.indexOf(95);
                        boolean isAbove6u23 = Integer.parseInt(JAVA_VERSION_TRIMMED.substring(subversionIndexStart + 1)) >= 23;
                        return isAbove6u23;
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
            }
        }
        return false;
    }

    private static boolean getJavaVersionMatches(String versionPrefix) {
        return UnderlyingSystemInfo.isJavaVersionMatch(JAVA_VERSION_TRIMMED, versionPrefix);
    }

    private static boolean isJavaVersionMatch(String version, String versionPrefix) {
        if (version == null) {
            return false;
        }
        return version.startsWith(versionPrefix);
    }

    private static String getJavaVersionTrimmed() {
        if (JAVA_VERSION_FULL != null) {
            for (int i = 0; i < JAVA_VERSION_FULL.length(); ++i) {
                char ch = JAVA_VERSION_FULL.charAt(i);
                if (ch < '0' || ch > '9') continue;
                return JAVA_VERSION_FULL.substring(i);
            }
        }
        return null;
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JvmProvider {
        SUN,
        ORACLE,
        IBM,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaVersion {
        JAVA_1_1,
        JAVA_1_2,
        JAVA_1_3,
        JAVA_1_4,
        JAVA_1_5,
        JAVA_1_6,
        JAVA_1_7,
        OTHER;

    }
}

