/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.serializer.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSchema {
    public static final String SCHEMA_EXT = ".sch";
    private static final String CLAZZ = "class";
    private String className;
    private Map<Integer, String> fieldMap;

    public ClassSchema() {
    }

    public ClassSchema(Map<String, String> initMap) {
        String className = initMap.get(CLAZZ);
        if (null == className) {
            throw new IllegalArgumentException("Schema initial map does not define the class.");
        }
        this.className = className;
        for (Map.Entry<String, String> entry : initMap.entrySet()) {
            if (entry.getKey().equals(CLAZZ)) continue;
            int fieldMarker = 0;
            try {
                fieldMarker = Integer.parseInt(entry.getKey());
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Schema initial map contains wrong data.", exception);
            }
            if (fieldMarker > 0 && null != entry.getValue()) {
                if (null == this.fieldMap) {
                    this.fieldMap = new HashMap<Integer, String>();
                }
                this.fieldMap.put(fieldMarker, entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Schema initial map contains wrong data.");
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getFieldName(int fieldMarker) {
        return this.fieldMap.get(fieldMarker);
    }

    public boolean isFieldExisting(int fieldMarker) {
        return this.fieldMap.containsKey(fieldMarker);
    }

    public Integer getFieldMarker(String fieldName) {
        if (this.fieldMap.containsValue(fieldName)) {
            for (Map.Entry<Integer, String> entry : this.fieldMap.entrySet()) {
                if (!entry.getValue().equals(fieldName)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("className", (Object)this.className);
        toStringBuilder.append("fieldMap", this.fieldMap);
        return toStringBuilder.toString();
    }
}

