/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.serializer.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import info.novatec.inspectit.util.IHibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateProxySerializer
extends Serializer<Object> {
    private IHibernateUtil hibernateUtil;
    private Serializer<Object> delegateSerializer;

    public HibernateProxySerializer(IHibernateUtil hibernateUtil, Serializer<Object> delegateSerializer) {
        if (null == hibernateUtil) {
            throw new IllegalArgumentException("HibernateUtil must not be null.");
        }
        if (null == delegateSerializer) {
            throw new IllegalArgumentException("Delegate serializer can not be null.");
        }
        this.hibernateUtil = hibernateUtil;
        this.delegateSerializer = delegateSerializer;
    }

    public Object read(Kryo kryo, Input input, Class<Object> type) {
        throw new RuntimeException("HibernateProxySerializer should never be used for reading.");
    }

    public void write(Kryo kryo, Output output, Object object) {
        this.delegateSerializer.write(kryo, output, this.hibernateUtil.getUnproxiedObject(object));
    }
}

