/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.stream;

import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import info.novatec.inspectit.storage.nio.ByteBufferProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
@Lazy
public class ExtendedByteBufferOutputStream
extends ByteBufferOutputStream {
    @Autowired
    ByteBufferProvider byteBufferProvider;
    private List<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();
    private volatile long totalWriteSize = 0L;
    private volatile boolean closed;

    public void flush() throws IOException {
        this.flush(true);
    }

    public void flush(boolean takeNewBuffer) throws IOException {
        ByteBuffer fullBuffer = super.getByteBuffer();
        fullBuffer.flip();
        this.byteBuffers.add(fullBuffer);
        this.totalWriteSize += (long)(fullBuffer.limit() - fullBuffer.position());
        if (takeNewBuffer) {
            ByteBuffer byteBuffer = this.byteBufferProvider.acquireByteBuffer();
            byteBuffer.clear();
            super.setByteBuffer(byteBuffer);
        } else {
            super.setByteBuffer(null);
        }
    }

    public void prepare() throws IOException {
        this.byteBuffers.clear();
        this.totalWriteSize = 0L;
        ByteBuffer byteBuffer = this.byteBufferProvider.acquireByteBuffer();
        byteBuffer.clear();
        super.setByteBuffer(byteBuffer);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = super.getByteBuffer().remaining();
        if (remaining >= len) {
            super.write(b, off, len);
        } else {
            super.write(b, off, remaining);
            this.flush();
            this.write(b, off + remaining, len - remaining);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        for (ByteBuffer byteBuffer : this.byteBuffers) {
            this.byteBufferProvider.releaseByteBuffer(byteBuffer);
        }
        this.byteBuffers.clear();
        ByteBuffer currentBuffer = super.getByteBuffer();
        if (null != currentBuffer) {
            this.byteBufferProvider.releaseByteBuffer(currentBuffer);
            super.setByteBuffer(null);
        }
        this.closed = true;
    }

    public List<ByteBuffer> getAllByteBuffers() {
        return new ArrayList<ByteBuffer>(this.byteBuffers);
    }

    public long getTotalWriteSize() {
        long size = this.totalWriteSize;
        ByteBuffer byteBuffer = super.getByteBuffer();
        if (null != byteBuffer) {
            size += (long)byteBuffer.position();
        }
        return size;
    }

    public int getBuffersCount() {
        int count = this.byteBuffers.size();
        ByteBuffer byteBuffer = super.getByteBuffer();
        if (null != byteBuffer) {
            ++count;
        }
        return count;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

