/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.minlog;

import com.esotericsoftware.minlog.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinlogToSLF4JLogger
extends Log.Logger {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinlogToSLF4JLogger.class);

    public static void init() {
        Log.set((int)3);
        Log.setLogger((Log.Logger)new MinlogToSLF4JLogger());
    }

    public void log(int level, String category, String message, Throwable ex) {
        switch (level) {
            case 1: {
                if (!LOGGER.isTraceEnabled()) break;
                LOGGER.trace(this.getMessage(category, message), ex);
                break;
            }
            case 2: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug(this.getMessage(category, message), ex);
                break;
            }
            case 3: {
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info(this.getMessage(category, message), ex);
                break;
            }
            case 4: {
                if (!LOGGER.isWarnEnabled()) break;
                LOGGER.warn(this.getMessage(category, message), ex);
                break;
            }
            case 5: {
                if (!LOGGER.isErrorEnabled()) break;
                LOGGER.error(this.getMessage(category, message), ex);
                break;
            }
        }
    }

    private String getMessage(String category, String message) {
        int size = category != null ? category.length() + 2 : (0 + message != null ? message.length() : 0);
        StringBuilder stringBuilder = new StringBuilder(size);
        if (null != category) {
            stringBuilder.append(category);
            stringBuilder.append(": ");
        }
        stringBuilder.append(message);
        return stringBuilder.toString();
    }
}

