/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.kryonet.rmi;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.rmi.RemoteObject;
import com.esotericsoftware.kryonet.rmi.TimeoutException;
import com.esotericsoftware.minlog.Log;
import info.novatec.inspectit.kryonet.Connection;
import info.novatec.inspectit.kryonet.Listener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSpace {
    private static final byte kReturnValMask = -128;
    private static final byte kReturnExMask = 64;
    private static final Object instancesLock = new Object();
    static ObjectSpace[] instances = new ObjectSpace[0];
    private static final HashMap<Class, CachedMethod[]> methodCache = new HashMap();
    final IntMap idToObject = new IntMap();
    Connection[] connections = new Connection[0];
    final Object connectionsLock = new Object();
    Executor executor;
    private final Listener invokeListener = new Listener(){

        public void received(final Connection connection, Object object) {
            if (!(object instanceof InvokeMethod)) {
                return;
            }
            if (ObjectSpace.this.connections != null) {
                int i;
                int n = ObjectSpace.this.connections.length;
                for (i = 0; i < n && connection != ObjectSpace.this.connections[i]; ++i) {
                }
                if (i == n) {
                    return;
                }
            }
            final InvokeMethod invokeMethod = (InvokeMethod)object;
            final Object target = ObjectSpace.this.idToObject.get(invokeMethod.objectID);
            if (target == null) {
                if (Log.WARN) {
                    Log.warn((String)"kryonet", (String)("Ignoring remote invocation request for unknown object ID: " + invokeMethod.objectID));
                }
                return;
            }
            if (ObjectSpace.this.executor == null) {
                ObjectSpace.this.invoke(connection, target, invokeMethod);
            } else {
                ObjectSpace.this.executor.execute(new Runnable(){

                    public void run() {
                        ObjectSpace.this.invoke(connection, target, invokeMethod);
                    }
                });
            }
        }

        public void disconnected(Connection connection) {
            ObjectSpace.this.removeConnection(connection);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSpace() {
        Object object = instancesLock;
        synchronized (object) {
            ObjectSpace[] instances = ObjectSpace.instances;
            ObjectSpace[] newInstances = new ObjectSpace[instances.length + 1];
            newInstances[0] = this;
            System.arraycopy(instances, 0, newInstances, 1, instances.length);
            ObjectSpace.instances = newInstances;
        }
    }

    public ObjectSpace(Connection connection) {
        this();
        this.addConnection(connection);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void register(int objectID, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.idToObject.put(objectID, object);
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)("Object registered with ObjectSpace as " + objectID + ": " + object));
        }
    }

    public void remove(int objectID) {
        Object object = this.idToObject.remove(objectID);
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)("Object " + objectID + " removed from ObjectSpace: " + object));
        }
    }

    public void remove(Object object) {
        if (!this.idToObject.containsValue(object, true)) {
            return;
        }
        int objectID = this.idToObject.findKey(object, true, -1);
        this.idToObject.remove(objectID);
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)("Object " + objectID + " removed from ObjectSpace: " + object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection[] connections = this.connections;
        for (int i = 0; i < connections.length; ++i) {
            connections[i].removeListener(this.invokeListener);
        }
        Object object = instancesLock;
        synchronized (object) {
            ArrayList<ObjectSpace> temp = new ArrayList<ObjectSpace>(Arrays.asList(instances));
            temp.remove(this);
            instances = temp.toArray(new ObjectSpace[temp.size()]);
        }
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)"Closed ObjectSpace.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        Object object = this.connectionsLock;
        synchronized (object) {
            Connection[] newConnections = new Connection[this.connections.length + 1];
            newConnections[0] = connection;
            System.arraycopy(this.connections, 0, newConnections, 1, this.connections.length);
            this.connections = newConnections;
        }
        connection.addListener(this.invokeListener);
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)("Added connection to ObjectSpace: " + connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        connection.removeListener(this.invokeListener);
        Object object = this.connectionsLock;
        synchronized (object) {
            ArrayList<Connection> temp = new ArrayList<Connection>(Arrays.asList(this.connections));
            temp.remove(connection);
            this.connections = temp.toArray(new Connection[temp.size()]);
        }
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)("Removed connection from ObjectSpace: " + connection));
        }
    }

    protected void invoke(Connection connection, Object target, InvokeMethod invokeMethod) {
        byte responseID;
        if (Log.DEBUG) {
            String argString = "";
            if (invokeMethod.args != null) {
                argString = Arrays.deepToString(invokeMethod.args);
                argString = argString.substring(1, argString.length() - 1);
            }
            Log.debug((String)"kryonet", (String)(connection + " received: " + target.getClass().getSimpleName() + "#" + invokeMethod.method.getName() + "(" + argString + ")"));
        }
        boolean transmitReturnVal = ((responseID = invokeMethod.responseID) & 0xFFFFFF80) == -128;
        boolean transmitExceptions = (responseID & 0x40) == 64;
        Object result = null;
        Method method = invokeMethod.method;
        try {
            result = method.invoke(target, invokeMethod.args);
        }
        catch (InvocationTargetException ex) {
            if (transmitExceptions) {
                result = ex.getCause();
            }
            throw new RuntimeException("Error invoking method: " + method.getDeclaringClass().getName() + "." + method.getName(), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error invoking method: " + method.getDeclaringClass().getName() + "." + method.getName(), ex);
        }
        if (responseID == 0) {
            return;
        }
        InvokeMethodResult invokeMethodResult = new InvokeMethodResult();
        invokeMethodResult.objectID = invokeMethod.objectID;
        invokeMethodResult.responseID = responseID;
        invokeMethodResult.result = !transmitReturnVal && !invokeMethod.method.getReturnType().isPrimitive() ? null : result;
        int length = connection.sendTCP(invokeMethodResult);
        if (Log.DEBUG) {
            Log.debug((String)"kryonet", (String)(connection + " sent: " + result + " (" + length + ")"));
        }
    }

    public static <T> T getRemoteObject(Connection connection, int objectID, Class<T> iface) {
        return (T)ObjectSpace.getRemoteObject(connection, objectID, new Class[]{iface});
    }

    public static RemoteObject getRemoteObject(Connection connection, int objectID, Class ... ifaces) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null.");
        }
        if (ifaces == null) {
            throw new IllegalArgumentException("ifaces cannot be null.");
        }
        Class[] temp = new Class[ifaces.length + 1];
        temp[0] = RemoteObject.class;
        System.arraycopy(ifaces, 0, temp, 1, ifaces.length);
        return (RemoteObject)Proxy.newProxyInstance(ObjectSpace.class.getClassLoader(), temp, (InvocationHandler)new RemoteInvocationHandler(connection, objectID));
    }

    static CachedMethod[] getMethods(Kryo kryo, Class type) {
        CachedMethod[] cachedMethods = methodCache.get(type);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        ArrayList allMethods = new ArrayList();
        for (Class nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Collections.addAll(allMethods, nextClass.getDeclaredMethods());
        }
        PriorityQueue<Method> methods = new PriorityQueue<Method>(Math.max(1, allMethods.size()), new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Class<?>[] argTypes2;
                int diff = o1.getName().compareTo(o2.getName());
                if (diff != 0) {
                    return diff;
                }
                Class<?>[] argTypes1 = o1.getParameterTypes();
                if (argTypes1.length > (argTypes2 = o2.getParameterTypes()).length) {
                    return 1;
                }
                if (argTypes1.length < argTypes2.length) {
                    return -1;
                }
                for (int i = 0; i < argTypes1.length; ++i) {
                    diff = argTypes1[i].getName().compareTo(argTypes2[i].getName());
                    if (diff == 0) continue;
                    return diff;
                }
                throw new RuntimeException("Two methods with same signature!");
            }
        });
        int n = allMethods.size();
        for (int i = 0; i < n; ++i) {
            Method method = (Method)allMethods.get(i);
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || method.isSynthetic()) continue;
            methods.add(method);
        }
        int n2 = methods.size();
        cachedMethods = new CachedMethod[n2];
        for (int i = 0; i < n2; ++i) {
            CachedMethod cachedMethod = new CachedMethod();
            cachedMethod.method = methods.poll();
            Class<?>[] parameterTypes = cachedMethod.method.getParameterTypes();
            cachedMethod.serializers = new Serializer[parameterTypes.length];
            int nn = parameterTypes.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (!kryo.isFinal(parameterTypes[ii])) continue;
                cachedMethod.serializers[ii] = kryo.getSerializer(parameterTypes[ii]);
            }
            cachedMethods[i] = cachedMethod;
        }
        methodCache.put(type, cachedMethods);
        return cachedMethods;
    }

    static Object getRegisteredObject(Connection connection, int objectID) {
        for (ObjectSpace objectSpace : instances) {
            Connection[] connections = objectSpace.connections;
            for (int j = 0; j < connections.length; ++j) {
                Object object;
                if (connections[j] != connection || (object = objectSpace.idToObject.get(objectID)) == null) continue;
                return object;
            }
        }
        return null;
    }

    public static void registerClasses(Kryo kryo) {
        kryo.register(Object[].class);
        kryo.register(InvokeMethod.class);
        FieldSerializer serializer = (FieldSerializer)kryo.register(InvokeMethodResult.class).getSerializer();
        serializer.getField("objectID").setClass(Integer.TYPE, (Serializer)new Serializer<Integer>(){

            public void write(Kryo kryo, Output output, Integer object) {
                output.writeInt(object.intValue(), true);
            }

            public Integer read(Kryo kryo, Input input, Class<Integer> type) {
                return input.readInt(true);
            }
        });
        kryo.register(InvocationHandler.class, new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                RemoteInvocationHandler handler = (RemoteInvocationHandler)Proxy.getInvocationHandler(object);
                output.writeInt(handler.objectID, true);
            }

            public Object read(Kryo kryo, Input input, Class type) {
                int objectID = input.readInt(true);
                Connection connection = (Connection)kryo.getContext().get((Object)"connection");
                Object object = ObjectSpace.getRegisteredObject(connection, objectID);
                if (Log.WARN && object == null) {
                    Log.warn((String)"kryonet", (String)("Unknown object ID " + objectID + " for connection: " + connection));
                }
                return object;
            }
        });
    }

    static class CachedMethod {
        Method method;
        Serializer[] serializers;

        CachedMethod() {
        }
    }

    public static class InvokeMethodResult
    implements FrameworkMessage {
        public int objectID;
        public byte responseID;
        public Object result;
    }

    public static class InvokeMethod
    implements FrameworkMessage,
    KryoSerializable {
        public int objectID;
        public Method method;
        public Object[] args;
        public byte responseID;

        public void write(Kryo kryo, Output output) {
            int i;
            output.writeInt(this.objectID, true);
            int methodClassID = kryo.getRegistration(this.method.getDeclaringClass()).getId();
            output.writeInt(methodClassID, true);
            CachedMethod[] cachedMethods = ObjectSpace.getMethods(kryo, this.method.getDeclaringClass());
            CachedMethod cachedMethod = null;
            int n = cachedMethods.length;
            for (i = 0; i < n; ++i) {
                cachedMethod = cachedMethods[i];
                if (!cachedMethod.method.equals(this.method)) continue;
                output.writeByte(i);
                break;
            }
            n = cachedMethod.serializers.length;
            for (i = 0; i < n; ++i) {
                Serializer serializer = cachedMethod.serializers[i];
                if (serializer != null) {
                    kryo.writeObjectOrNull(output, this.args[i], serializer);
                    continue;
                }
                kryo.writeClassAndObject(output, this.args[i]);
            }
            output.writeByte(this.responseID);
        }

        public void read(Kryo kryo, Input input) {
            CachedMethod cachedMethod;
            this.objectID = input.readInt(true);
            int methodClassID = input.readInt(true);
            Class methodClass = kryo.getRegistration(methodClassID).getType();
            byte methodIndex = input.readByte();
            try {
                cachedMethod = ObjectSpace.getMethods(kryo, methodClass)[methodIndex];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new KryoException("Invalid method index " + methodIndex + " for class: " + methodClass.getName());
            }
            this.method = cachedMethod.method;
            this.args = new Object[cachedMethod.serializers.length];
            int n = this.args.length;
            for (int i = 0; i < n; ++i) {
                Serializer serializer = cachedMethod.serializers[i];
                this.args[i] = serializer != null ? kryo.readObjectOrNull(input, this.method.getParameterTypes()[i], serializer) : kryo.readClassAndObject(input);
            }
            this.responseID = input.readByte();
        }
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Connection connection;
        final int objectID;
        private int timeoutMillis = 3000;
        private boolean nonBlocking = false;
        private boolean transmitReturnValue = true;
        private boolean transmitExceptions = true;
        private Byte lastResponseID;
        private byte nextResponseNum = 1;
        private Listener responseListener;
        final ReentrantLock lock = new ReentrantLock();
        final Condition responseCondition = this.lock.newCondition();
        final ConcurrentHashMap<Byte, InvokeMethodResult> responseTable = new ConcurrentHashMap();

        public RemoteInvocationHandler(Connection connection, final int objectID) {
            this.connection = connection;
            this.objectID = objectID;
            this.responseListener = new Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void received(Connection connection, Object object) {
                    if (!(object instanceof InvokeMethodResult)) {
                        return;
                    }
                    InvokeMethodResult invokeMethodResult = (InvokeMethodResult)object;
                    if (invokeMethodResult.objectID != objectID) {
                        return;
                    }
                    RemoteInvocationHandler.this.responseTable.put(invokeMethodResult.responseID, invokeMethodResult);
                    RemoteInvocationHandler.this.lock.lock();
                    try {
                        RemoteInvocationHandler.this.responseCondition.signalAll();
                    }
                    finally {
                        RemoteInvocationHandler.this.lock.unlock();
                    }
                }

                public void disconnected(Connection connection) {
                    RemoteInvocationHandler.this.close();
                }
            };
            connection.addListener(this.responseListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            boolean needsResponse;
            if (method.getDeclaringClass() == RemoteObject.class) {
                String name = method.getName();
                if (name.equals("close")) {
                    this.close();
                    return null;
                }
                if (name.equals("setResponseTimeout")) {
                    this.timeoutMillis = (Integer)args[0];
                    return null;
                }
                if (name.equals("setNonBlocking")) {
                    this.nonBlocking = (Boolean)args[0];
                    return null;
                }
                if (name.equals("setTransmitReturnValue")) {
                    this.transmitReturnValue = (Boolean)args[0];
                    return null;
                }
                if (name.equals("setTransmitExceptions")) {
                    this.transmitExceptions = (Boolean)args[0];
                    return null;
                }
                if (name.equals("waitForLastResponse")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response to wait for.");
                    }
                    return this.waitForResponse(this.lastResponseID);
                }
                if (name.equals("getLastResponseID")) {
                    if (this.lastResponseID == null) {
                        throw new IllegalStateException("There is no last response ID.");
                    }
                    return this.lastResponseID;
                }
                if (name.equals("waitForResponse")) {
                    if (!this.transmitReturnValue && !this.transmitExceptions && this.nonBlocking) {
                        throw new IllegalStateException("This RemoteObject is currently set to ignore all responses.");
                    }
                    return this.waitForResponse((Byte)args[0]);
                }
                if (name.equals("getConnection")) {
                    return this.connection;
                }
                throw new RuntimeException("Invocation handler could not find RemoteObject method. Check ObjectSpace.java");
            }
            if (method.getDeclaringClass() == Object.class) {
                if (method.getName().equals("toString")) {
                    return "<proxy>";
                }
                try {
                    return method.invoke(proxy, args);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            InvokeMethod invokeMethod = new InvokeMethod();
            invokeMethod.objectID = this.objectID;
            invokeMethod.method = method;
            invokeMethod.args = args;
            boolean bl = needsResponse = this.transmitReturnValue || this.transmitExceptions || !this.nonBlocking;
            if (needsResponse) {
                byte responseID;
                RemoteInvocationHandler remoteInvocationHandler = this;
                synchronized (remoteInvocationHandler) {
                    byte by = this.nextResponseNum;
                    this.nextResponseNum = (byte)(by + 1);
                    responseID = by;
                    if (this.nextResponseNum == 64) {
                        this.nextResponseNum = 1;
                    }
                }
                if (this.transmitReturnValue) {
                    responseID = (byte)(responseID | 0xFFFFFF80);
                }
                if (this.transmitExceptions) {
                    responseID = (byte)(responseID | 0x40);
                }
                invokeMethod.responseID = responseID;
            } else {
                invokeMethod.responseID = 0;
            }
            int length = this.connection.sendTCP(invokeMethod);
            if (Log.DEBUG) {
                String argString = "";
                if (args != null) {
                    argString = Arrays.deepToString(args);
                    argString = argString.substring(1, argString.length() - 1);
                }
                Log.debug((String)"kryonet", (String)(this.connection + " sent: " + method.getDeclaringClass().getSimpleName() + "#" + method.getName() + "(" + argString + ") (" + length + ")"));
            }
            if (invokeMethod.responseID != 0) {
                this.lastResponseID = invokeMethod.responseID;
            }
            if (this.nonBlocking) {
                Class<?> returnType = method.getReturnType();
                if (returnType.isPrimitive()) {
                    if (returnType == Integer.TYPE) {
                        return 0;
                    }
                    if (returnType == Boolean.TYPE) {
                        return Boolean.FALSE;
                    }
                    if (returnType == Float.TYPE) {
                        return Float.valueOf(0.0f);
                    }
                    if (returnType == Character.TYPE) {
                        return Character.valueOf('\u0000');
                    }
                    if (returnType == Long.TYPE) {
                        return 0L;
                    }
                    if (returnType == Short.TYPE) {
                        return (short)0;
                    }
                    if (returnType == Byte.TYPE) {
                        return (byte)0;
                    }
                    if (returnType == Double.TYPE) {
                        return 0.0;
                    }
                }
                return null;
            }
            try {
                Object result = this.waitForResponse(invokeMethod.responseID);
                if (result != null && result instanceof Exception) {
                    throw (Exception)result;
                }
                return result;
            }
            catch (TimeoutException ex) {
                throw new TimeoutException("Response timed out: " + method.getDeclaringClass().getName() + "." + method.getName());
            }
        }

        private Object waitForResponse(byte responseID) {
            if (this.connection.getEndPoint().getUpdateThread() == Thread.currentThread()) {
                throw new IllegalStateException("Cannot wait for an RMI response on the connection's update thread.");
            }
            long endTime = System.currentTimeMillis() + (long)this.timeoutMillis;
            while (true) {
                long remaining = endTime - System.currentTimeMillis();
                if (this.responseTable.containsKey(responseID)) {
                    InvokeMethodResult invokeMethodResult = this.responseTable.get(responseID);
                    this.responseTable.remove(responseID);
                    this.lastResponseID = null;
                    return invokeMethodResult.result;
                }
                if (remaining <= 0L) {
                    throw new TimeoutException("Response timed out.");
                }
                this.lock.lock();
                try {
                    this.responseCondition.await(remaining, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        void close() {
            this.connection.removeListener(this.responseListener);
        }
    }
}

