/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.kryonet;

import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.minlog.Log;
import info.novatec.inspectit.kryonet.Connection;
import info.novatec.inspectit.kryonet.IExtendedSerialization;
import info.novatec.inspectit.storage.nio.stream.ExtendedByteBufferOutputStream;
import info.novatec.inspectit.storage.nio.stream.SocketExtendedByteBufferInputStream;
import info.novatec.inspectit.storage.nio.stream.StreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class TcpConnection {
    private static final int IPTOS_LOWDELAY = 16;
    private StreamProvider streamProvider;
    private Lock writeReentrantLock = new ReentrantLock();
    private LinkedBlockingQueue<ExtendedByteBufferOutputStream> writeQueue = new LinkedBlockingQueue();
    private SocketExtendedByteBufferInputStream socketInputStream;
    SocketChannel socketChannel;
    int keepAliveMillis = 8000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    boolean bufferPositionFix;
    int timeoutMillis = 12000;
    float idleThreshold = 0.1f;
    final IExtendedSerialization serialization;
    private SelectionKey selectionKey;
    private long lastWriteTime;
    private long lastReadTime;
    private int currentObjectLength;
    private final Object writeLock = new Object();

    public TcpConnection(IExtendedSerialization serialization, int writeBufferSize, int objectBufferSize, StreamProvider streamProvider) {
        this.serialization = serialization;
        this.streamProvider = streamProvider;
        this.writeBuffer = ByteBuffer.allocate(writeBufferSize);
        this.readBuffer = ByteBuffer.allocate(objectBufferSize);
        this.readBuffer.flip();
    }

    public SelectionKey accept(Selector selector, SocketChannel socketChannel) throws IOException {
        this.readBuffer.clear();
        this.readBuffer.flip();
        this.currentObjectLength = 0;
        try {
            this.socketChannel = socketChannel;
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            this.selectionKey = socketChannel.register(selector, 1);
            if (Log.DEBUG) {
                Log.debug((String)"kryonet", (String)("Port " + socketChannel.socket().getLocalPort() + "/TCP connected to: " + socketChannel.socket().getRemoteSocketAddress()));
            }
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
            this.socketInputStream = this.streamProvider.getSocketExtendedByteBufferInputStream(socketChannel);
            return this.selectionKey;
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void connect(Selector selector, SocketAddress remoteAddress, int timeout) throws IOException {
        this.close();
        this.readBuffer.clear();
        this.readBuffer.flip();
        this.currentObjectLength = 0;
        try {
            SocketChannel socketChannel = selector.provider().openSocketChannel();
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.connect(remoteAddress, timeout);
            socketChannel.configureBlocking(false);
            this.socketChannel = socketChannel;
            this.selectionKey = socketChannel.register(selector, 1);
            this.selectionKey.attach(this);
            if (Log.DEBUG) {
                Log.debug((String)"kryonet", (String)("Port " + socketChannel.socket().getLocalPort() + "/TCP connected to: " + socketChannel.socket().getRemoteSocketAddress()));
            }
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
            this.socketInputStream = this.streamProvider.getSocketExtendedByteBufferInputStream(socketChannel);
        }
        catch (IOException ex) {
            this.close();
            IOException ioEx = new IOException("Unable to connect to: " + remoteAddress);
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    public Object readObject(Connection connection) throws IOException {
        Object object;
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        if (this.currentObjectLength == 0) {
            int lengthLength = this.serialization.getLengthLength();
            if (this.readBuffer.remaining() < lengthLength) {
                this.readBuffer.compact();
                int bytesRead = socketChannel.read(this.readBuffer);
                this.readBuffer.flip();
                if (bytesRead == -1) {
                    throw new SocketException("Connection is closed.");
                }
                this.lastReadTime = System.currentTimeMillis();
                if (this.readBuffer.remaining() < lengthLength) {
                    return null;
                }
            }
            this.currentObjectLength = this.serialization.readLength(this.readBuffer);
            if (this.currentObjectLength <= 0) {
                throw new KryoNetException("Invalid object length: " + this.currentObjectLength);
            }
        }
        int length = this.currentObjectLength;
        this.socketInputStream.reset(length);
        this.lastReadTime = System.currentTimeMillis();
        this.currentObjectLength = 0;
        try {
            object = this.serialization.read(connection, (InputStream)((Object)this.socketInputStream));
        }
        catch (Exception ex) {
            throw new KryoNetException("Error during deserialization.", (Throwable)ex);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOperation() throws IOException {
        this.writeReentrantLock.lock();
        try {
            if (this.writeToSocket()) {
                this.selectionKey.interestOps(1);
            }
            this.lastWriteTime = System.currentTimeMillis();
        }
        finally {
            this.writeReentrantLock.unlock();
        }
    }

    private boolean writeToSocket() throws IOException {
        ExtendedByteBufferOutputStream outputStream;
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        block0: while (!this.writeQueue.isEmpty() && null != (outputStream = this.writeQueue.peek())) {
            long written = 0L;
            List<ByteBuffer> buffers = outputStream.getAllByteBuffers();
            for (ByteBuffer buffer : buffers) {
                written += (long)buffer.position();
            }
            while (written < outputStream.getTotalWriteSize()) {
                long writeSize = socketChannel.write(buffers.toArray(new ByteBuffer[buffers.size()]));
                if (0L == writeSize) break block0;
                written += writeSize;
            }
            outputStream.close();
            this.writeQueue.remove((Object)outputStream);
        }
        return this.writeQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Connection connection, Object object) throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        this.writeReentrantLock.lock();
        try {
            ExtendedByteBufferOutputStream outputStream = this.streamProvider.getExtendedByteBufferOutputStream();
            int lengthLength = this.serialization.getLengthLength();
            outputStream.write(new byte[lengthLength]);
            try {
                this.serialization.write(connection, (OutputStream)((Object)outputStream), object);
            }
            catch (KryoNetException ex) {
                outputStream.close();
                throw new KryoNetException("Error serializing object of type: " + object.getClass().getName(), (Throwable)ex);
            }
            outputStream.flush(false);
            long writeSize = outputStream.getTotalWriteSize() - (long)lengthLength;
            ByteBuffer buffer = outputStream.getAllByteBuffers().iterator().next();
            int position = buffer.position();
            buffer.position(0);
            this.serialization.writeLength(buffer, (int)writeSize);
            buffer.position(position);
            boolean hasQueuedData = this.hasQueuedData();
            this.writeQueue.add(outputStream);
            if (!hasQueuedData && !this.writeToSocket()) {
                this.selectionKey.interestOps(5);
            } else {
                this.selectionKey.selector().wakeup();
            }
            this.lastWriteTime = System.currentTimeMillis();
            int n = (int)writeSize;
            return n;
        }
        finally {
            this.writeReentrantLock.unlock();
        }
    }

    private boolean hasQueuedData() {
        return !this.writeQueue.isEmpty();
    }

    public void close() {
        block6: {
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                    this.socketChannel = null;
                    if (this.selectionKey != null) {
                        this.selectionKey.selector().wakeup();
                    }
                }
                if (null != this.socketInputStream) {
                    this.socketInputStream.close();
                }
                while (!this.writeQueue.isEmpty()) {
                    ExtendedByteBufferOutputStream outputStream = this.writeQueue.poll();
                    if (null == outputStream) continue;
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                if (!Log.DEBUG) break block6;
                Log.debug((String)"kryonet", (String)"Unable to close TCP connection.", (Throwable)ex);
            }
        }
    }

    public boolean needsKeepAlive(long time) {
        return this.socketChannel != null && this.keepAliveMillis > 0 && time - this.lastWriteTime > (long)this.keepAliveMillis;
    }

    public boolean isTimedOut(long time) {
        return this.socketChannel != null && this.timeoutMillis > 0 && time - this.lastReadTime > (long)this.timeoutMillis;
    }

    public int getWriteBuffersSize() {
        if (this.writeQueue.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (ExtendedByteBufferOutputStream stream : this.writeQueue) {
            size = (int)((long)size + stream.getTotalWriteSize());
        }
        return size;
    }
}

