/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.exception.enumeration;

import info.novatec.inspectit.exception.IErrorCode;
import org.apache.commons.lang.WordUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StorageErrorCodeEnum implements IErrorCode
{
    STORAGE_NAME_IS_NOT_PROVIDED("Creating a storage requires to provide a name for new storage.", null, null),
    STORAGE_DOES_NOT_EXIST("The storage to execute the selected operation on does not exist.", "The storage might be deleted.", null),
    STORAGE_IS_NOT_CLOSED("The storage to execute the selected operation on is not yet closed.", null, "Close the storage first and try again."),
    STORAGE_IS_NOT_OPENED("The storage to execute the selected operation on is not yet opened.", null, "Open the storage first and try again."),
    STORAGE_CAN_NOT_BE_REOPENED("Attempt has been made to open already closed storage.", null, null),
    STORAGE_CAN_NOT_BE_CLOSED("The selected storage can not be closed at the moment.", "Storage is currently used for recording or recording has been scheduled.", null),
    STORAGE_ALREADY_CLOSED("The storage to execute the selected operation on is closed.", null, null),
    STORAGE_ALREADY_DOWNLOADED("The selected storage is already fully downloaded.", null, null),
    STORAGE_IS_NOT_DOWNLOADED("The operation to execute failed because the selected storage is not fully downloaded.", null, "Download the storage first and try again."),
    CAN_NOT_START_RECORDING("The recording can not be started at the moment.", "Recording is already active.", "Stop the recording if the one is currently active."),
    WRITE_FAILED("Writing data to the storage failed.", "Storage is currently used for recording.", null),
    LOW_DISK_SPACE("The operation to execute failed due to the low amount of the space on the hard drive.", null, "Provide additional space on the hard drive."),
    FILE_DOES_NOT_EXIST("The file or directory does not exist on the given path.", null, null),
    LABEL_TYPE_CAN_NOT_BE_DELETED("Label types can not be deleted if any label of the selected type still exists.", null, "Delete first all labels of the selected type and try again."),
    SERIALIZATION_FAILED("(De-)Serialization of storage data bytes failed.", "CMR version for the storage not compatible.", "Perform the action with the compatible version of the CMR."),
    INPUT_OUTPUT_OPERATION_FAILED("IO operation failed trying to read or write the storage data bytes.", null, "Check disk status and that the write/read permissions exist.");

    private static final String COMPONENT_NAME = "Storage";
    private final String description;
    private final String possibleCause;
    private final String possibleSolution;

    private StorageErrorCodeEnum(String description, String possibleCause, String possibleSolution) {
        if (null == description) {
            throw new IllegalArgumentException("Description for the error code must not be null");
        }
        this.description = description;
        this.possibleCause = possibleCause;
        this.possibleSolution = possibleSolution;
    }

    @Override
    public String getComponent() {
        return COMPONENT_NAME;
    }

    @Override
    public String getName() {
        return WordUtils.capitalizeFully((String)this.toString().replace("_", " ").toLowerCase());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPossibleCause() {
        return this.possibleCause;
    }

    @Override
    public String getPossibleSolution() {
        return this.possibleSolution;
    }
}

