/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.valueobject;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.TimerData;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerRawVO
extends MethodSensorData {
    private static final long serialVersionUID = 6176694438175985136L;
    private List<TimerRawContainer> data = new ArrayList<TimerRawContainer>();
    private TimerRawContainer container = new TimerRawContainer();
    private boolean charting;

    public TimerRawVO(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, List<ParameterContentData> parameterContentData, boolean charting) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData);
        this.charting = charting;
        this.data.add(this.container);
    }

    public void add(double time) {
        this.createContainerIfNecessary();
        this.container.add(time);
    }

    public void add(double time, double cpuTime) {
        this.createContainerIfNecessary();
        this.container.add(time, cpuTime);
    }

    private void createContainerIfNecessary() {
        if (this.container.isFull()) {
            this.container = new TimerRawContainer();
            this.data.add(this.container);
        }
    }

    public List<TimerRawContainer> getData() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public DefaultData finalizeData() {
        TimerData timerData = new TimerData(this.getTimeStamp(), this.getPlatformIdent(), this.getSensorTypeIdent(), this.getMethodIdent());
        timerData.setParameterContentData(this.getParameterContentData());
        timerData.setCharting(this.charting);
        double min = Double.MAX_VALUE;
        double max = 0.0;
        int count = 0;
        double duration = 0.0;
        double cpuMin = Double.MAX_VALUE;
        double cpuMax = 0.0;
        double cpuDuration = 0.0;
        for (TimerRawContainer container : this.data) {
            double value;
            int j;
            double[] values = container.getData();
            for (j = 0; j < container.getCount(); ++j) {
                value = values[j];
                duration += value;
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            count += container.getCount();
            values = container.getCpuData();
            if (null == values) continue;
            for (j = 0; j < container.getCount(); ++j) {
                value = values[j];
                cpuDuration += value;
                if (value < cpuMin) {
                    cpuMin = value;
                }
                if (!(value > cpuMax)) continue;
                cpuMax = value;
            }
        }
        timerData.calculateMin(min);
        timerData.calculateMax(max);
        timerData.setCount(count);
        timerData.setDuration(duration);
        timerData.setVariance(-1.0);
        if (Double.MAX_VALUE != cpuMin) {
            timerData.calculateCpuMin(cpuMin);
            timerData.calculateCpuMax(cpuMax);
            timerData.setCpuDuration(cpuDuration);
        }
        return timerData;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimerRawVO other = (TimerRawVO)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public static class TimerRawContainer
    implements Serializable {
        private static final long serialVersionUID = 7225384620786119269L;
        private static final int MAX_SIZE = 50;
        private double[] data = new double[50];
        private double[] cpuData = new double[50];
        private int count = 0;

        public void add(double time) {
            this.data[this.count] = time;
            ++this.count;
            if (null != this.cpuData) {
                this.cpuData = null;
            }
        }

        public void add(double time, double cpuTime) {
            this.data[this.count] = time;
            this.cpuData[this.count] = cpuTime;
            ++this.count;
        }

        public boolean isFull() {
            return this.count == 49;
        }

        public int getCount() {
            return this.count;
        }

        public double[] getData() {
            return this.data;
        }

        public double[] getCpuData() {
            return this.cpuData;
        }

        private static int hashCode(double[] array) {
            int prime = 31;
            if (array == null) {
                return 0;
            }
            int result = 1;
            for (int index = 0; index < array.length; ++index) {
                long temp = Double.doubleToLongBits(array[index]);
                result = prime * result + (int)(temp ^ temp >>> 32);
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.count;
            result = 31 * result + TimerRawContainer.hashCode(this.cpuData);
            result = 31 * result + TimerRawContainer.hashCode(this.data);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimerRawContainer other = (TimerRawContainer)obj;
            if (this.count != other.count) {
                return false;
            }
            if (!Arrays.equals(this.cpuData, other.cpuData)) {
                return false;
            }
            return Arrays.equals(this.data, other.data);
        }
    }
}

