/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.Sizeable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang.StringUtils;

@Entity
public class VmArgumentData
implements Serializable,
Sizeable {
    private static final long serialVersionUID = -8210901536567725333L;
    private static final int MAX_LENGTH = 10000;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="VM_DATA_SEQUENCE")
    @SequenceGenerator(name="VM_DATA_SEQUENCE", sequenceName="VM_DATA_SEQUENCE")
    private long id;
    @Column(length=10000)
    private String vmName;
    @Column(length=10000)
    private String vmValue;

    public VmArgumentData() {
    }

    public VmArgumentData(String vmName, String vmValue) {
        this.vmName = vmName;
        this.vmValue = vmValue;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVmValue() {
        return this.vmValue;
    }

    public void setVmValue(String vmValue) {
        this.vmValue = vmValue;
    }

    @PrePersist
    protected void checkLengths() {
        if (StringUtils.isNotEmpty((String)this.vmName) && this.vmName.length() > 10000) {
            this.vmName = this.vmName.substring(0, 10000);
        }
        if (StringUtils.isNotEmpty((String)this.vmValue) && this.vmValue.length() > 10000) {
            this.vmValue = this.vmValue.substring(0, 10000);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vmName == null ? 0 : this.vmName.hashCode());
        result = 31 * result + (this.vmValue == null ? 0 : this.vmValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmArgumentData other = (VmArgumentData)obj;
        if (this.vmName == null ? other.vmName != null : !this.vmName.equals(other.vmName)) {
            return false;
        }
        return !(this.vmValue == null ? other.vmValue != null : !this.vmValue.equals(other.vmValue));
    }

    public long getObjectSize(IObjectSizes objectSizes) {
        return this.getObjectSize(objectSizes, true);
    }

    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(2, 0, 0, 0, 1, 0);
        size += objectSizes.getSizeOf(this.vmName, this.vmValue);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

