/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.data.TimerData;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStatementData
extends TimerData {
    private static final long serialVersionUID = 8925352913101724757L;
    private String sql;
    private String databaseUrl;
    private String databaseProductName;
    private String databaseProductVersion;
    private boolean preparedStatement = false;
    private List<String> parameterValues;
    private transient String sqlWithParameterValues;

    public SqlStatementData() {
    }

    public SqlStatementData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        this(timeStamp, platformIdent, sensorTypeIdent, methodIdent, (String)null);
    }

    public SqlStatementData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, String sqlQueryString) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
        this.sql = sqlQueryString;
    }

    public SqlStatementData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, String sqlQueryString, String databaseUrl, String databaseProductVersion, String databaseProductName) {
        this(timeStamp, platformIdent, sensorTypeIdent, methodIdent, sqlQueryString);
        this.databaseUrl = databaseUrl;
        this.databaseProductVersion = databaseProductVersion;
        this.databaseProductName = databaseProductName;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean isPreparedStatement() {
        return this.preparedStatement;
    }

    public void setPreparedStatement(boolean preparedStatement) {
        this.preparedStatement = preparedStatement;
    }

    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List<String> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public String getSqlWithParameterValues() {
        if (null == this.parameterValues || this.parameterValues.isEmpty()) {
            return this.sql;
        }
        if (null == this.sqlWithParameterValues) {
            int index = 0;
            StringBuilder stringBuilder = new StringBuilder(this.sql.length());
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if ('?' == c) {
                    String parameter = this.parameterValues.get(index);
                    if (null == parameter || "".equals(parameter.trim())) {
                        stringBuilder.append(c);
                    } else {
                        stringBuilder.append(parameter);
                    }
                    ++index;
                    continue;
                }
                stringBuilder.append(c);
            }
            this.sqlWithParameterValues = stringBuilder.toString();
        }
        return this.sqlWithParameterValues;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        result = 31 * result + (this.preparedStatement ? 1231 : 1237);
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        result = 31 * result + (this.databaseUrl == null ? 0 : this.databaseUrl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlStatementData other = (SqlStatementData)obj;
        if (this.parameterValues == null ? other.parameterValues != null : !this.parameterValues.equals(other.parameterValues)) {
            return false;
        }
        if (this.preparedStatement != other.preparedStatement) {
            return false;
        }
        if (this.sql == null ? other.sql != null : !this.sql.equals(other.sql)) {
            return false;
        }
        return !(this.databaseUrl == null ? other.databaseUrl != null : !this.databaseUrl.equals(other.databaseUrl));
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(6, 1, 0, 0, 0, 0);
        size += objectSizes.getSizeOf(this.sql);
        size += objectSizes.getSizeOf(this.databaseProductName);
        size += objectSizes.getSizeOf(this.databaseProductVersion);
        size += objectSizes.getSizeOf(this.databaseUrl);
        if (this.parameterValues != null) {
            size += objectSizes.getSizeOf(this.parameterValues);
            for (String str : this.parameterValues) {
                size += objectSizes.getSizeOf(str);
            }
        }
        if (null != this.sqlWithParameterValues) {
            size += objectSizes.getSizeOf(this.sqlWithParameterValues);
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

